/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.gson.reference;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.DtoReferenceCollection;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;

public abstract class ReferenceCollectionSupportAdapter<R extends DtoReference, S extends DtoReferenceCollection<R>>
implements JsonDeserializer<S> {
    public final S deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        Class referenceType = (Class)context.deserialize(jsonObject.get("type"), Class.class);
        JsonArray jsonPropertyValues = jsonObject.get("references").getAsJsonArray();
        int referencesSize = jsonPropertyValues.size();
        LinkedList<DtoReference> references = new LinkedList<DtoReference>();
        for (int i = 0; i < referencesSize; ++i) {
            DtoReference reference = (DtoReference)context.deserialize(jsonPropertyValues.get(i), (Type)referenceType);
            references.add(reference);
        }
        return this.newReferenceSet(referenceType, references, jsonObject, context);
    }

    protected abstract S newReferenceSet(Class<R> var1, List<R> var2, JsonObject var3, JsonDeserializationContext var4);
}

