package fr.ird.observe.spi.map;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2019 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.dto.IdHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;

/**
 * A special map to store string values using the {@link #key0(Class)} method to produce keys.
 * <p>
 * Created by tchemit on 01/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class MutableDtoMap<V> {

    private static final transient Function<Class, String> keyFunction = IdHelper::getDtoSimplifiedName;
    private final Map<String, V> data;

    public static <V> MutableDtoMap<V> create() {
        return new MutableDtoMap<>();
    }

    protected MutableDtoMap(MutableDtoMap<V> dtoMap) {
        this.data = dtoMap.data;
    }

    private MutableDtoMap() {
        this.data = new TreeMap<>();
    }

    public int size() {
        return data.size();
    }

    public boolean isEmpty() {
        return data.isEmpty();
    }

    public V get(Class key) {
        return data.get(key0(key));
    }

    public Set<String> keySet() {
        return data.keySet();
    }

    public Collection<V> values() {
        return data.values();
    }

    public void put(Class type, V value) {
        data.put(key0(type), value);
    }

    public void clear() {
        data.clear();
    }

    protected String key0(Class type) {
        return keyFunction.apply(type);
    }

}
