package fr.ird.observe.spi.initializer;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2019 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.spi.map.DtoToDtoClassMap;

public abstract class DtoToMainDtoInitializerSupport {

    private final ImmutableMap.Builder<Class, Class> dtoToMainDtoClassMappingBuilder = ImmutableMap.builder();

    private DtoToDtoClassMap dtoToMainDtoClassMapping;

    public DtoToDtoClassMap getDtoToMainDtoClassMapping() {
        return dtoToMainDtoClassMapping;
    }

    public void end() {
        dtoToMainDtoClassMapping = new DtoToDtoClassMap(dtoToMainDtoClassMappingBuilder.build());
    }


    protected <D extends IdDto, F extends IdDto> void addClassMapping(Class<D> dtoType, Class<F> mainDtoType) {
        dtoToMainDtoClassMappingBuilder.put(dtoType, mainDtoType);
    }

}
