package fr.ird.observe.spi.context;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2019 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.form.FormDefinition;

/**
 * Created by tchemit on 06/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class DataFormContext<D extends DataDto, F extends DataDto> implements FormContext<D, F> {

    private final Class<D> dtoType;
    private final Class<F> formType;
    private final FormDefinition<F> formDefinition;

    public DataFormContext(Class<D> dtoType, Class<F> formType, FormDefinition<F> formDefinition) {
        this.dtoType = dtoType;
        this.formType = formType;
        this.formDefinition = formDefinition;
    }

    @Override
    public Class<D> toDtoType() {
        return dtoType;
    }

    @Override
    public Class<F> toFormType() {
        return formType;
    }

    @Override
    public FormDefinition<F> toFormDefinition() {
        return formDefinition;
    }

}

