package fr.ird.observe.navigation.model;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2019 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableList;
import fr.ird.observe.dto.IdDto;
import io.ultreia.java4all.bean.JavaBean;

import java.util.Objects;

/**
 * Created by tchemit on 26/05/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public interface DtoModelNavigationModel<N extends DtoModelNavigationNode> extends JavaBean {

    String PROPERTY_ENABLED = "enabled";

    String getModel();

    boolean accept(IdDto dto);

    <D extends IdDto> DtoModelNavigationNode<D> getDtoNode(Class<D> type);

    <D extends IdDto> DtoModelNavigationNode<D> getNavigationNode(DtoModelNavigationNode<?> node);

    <D extends DtoModelNavigationNode> D getNode(Class<D> type);

    N getRoot();

    ImmutableList<N> getNodes();

    ImmutableList<N> getNodesWithIds();

    default boolean isEnabled() {
        return getRoot().isEnabled();
    }

    default boolean isDisabled() {
        return !isEnabled();
    }

    default boolean acceptModel(String model) {
        return Objects.equals(getModel(), model);
    }

    default void load(DtoModelNavigationModel<?> model) {
        for (DtoModelNavigationNode n : model.getNodesWithIds()) {
            getNode(n.getClass()).setId(n.getId());
        }
    }

    default int count() {
        return (int) getNodes().stream().filter(DtoModelNavigationNode::isEnabled).count();
    }

    default void clearModel() {
        getNodes().forEach(n -> n.setId(null));
    }
}
