package fr.ird.observe.dto.referential;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2019 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.MoreObjects;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceAware;

import static fr.ird.observe.dto.reference.ReferentialDtoReference.PROPERTY_ENABLED;

public abstract class ReferentialDto extends IdDto implements ReferentialDtoReferenceAware {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CODE = "code";

    public static final String PROPERTY_STATUS = "status";

    public static final String PROPERTY_URI = "uri";

    public static final String PROPERTY_NEED_COMMENT = "needComment";

    public static final String PROPERTY_VERSION = "version";

    public static final String PROPERTY_CREATE_DATE = "createDate";

    public static final String PROPERTY_HOME_ID = "homeId";

    public boolean isEnabled() {
        return ReferenceStatus.enabled == status;
    }

    protected String code;

    protected ReferenceStatus status;

    protected String uri;
    protected String homeId;

    protected boolean needComment;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        String oldValue = getCode();
        this.code = code;
        firePropertyChange(PROPERTY_CODE, oldValue, code);
    }

    public ReferenceStatus getStatus() {
        return status;
    }

    public void setStatus(ReferenceStatus status) {
        ReferenceStatus oldValue = getStatus();
        this.status = status;
        firePropertyChange(PROPERTY_STATUS, oldValue, status);
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        String oldValue = getUri();
        this.uri = uri;
        firePropertyChange(PROPERTY_URI, oldValue, uri);
    }

    public boolean isNeedComment() {
        return needComment;
    }

    public void setNeedComment(boolean needComment) {
        boolean oldValue = isNeedComment();
        this.needComment = needComment;
        firePropertyChange(PROPERTY_NEED_COMMENT, oldValue, needComment);
    }

    public String getHomeId() {
        return homeId;
    }

    public void setHomeId(String homeId) {
        String oldValue = getHomeId();
        this.homeId = homeId;
        firePropertyChange(PROPERTY_HOME_ID, oldValue, homeId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add(PROPERTY_ID, id)
                .add(PROPERTY_HOME_ID, homeId)
                .add(PROPERTY_ENABLED, isEnabled())
                .add(PROPERTY_NEED_COMMENT, needComment)
                .add(PROPERTY_CREATE_DATE, createDate)
                .add(PROPERTY_LAST_UPDATE_DATE, lastUpdateDate)
                .add(PROPERTY_VERSION, version)
                .toString();
    }

}
