/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdHelper;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;

public class ImmutableDtoMap<V> {
    private static final transient Function<Class, String> keyFunction = IdHelper::getDtoSimplifiedName;
    private final ImmutableMap<String, V> data;

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    protected ImmutableDtoMap(ImmutableDtoMap<V> dtoMap) {
        this.data = dtoMap.data;
    }

    protected ImmutableDtoMap(ImmutableMap<String, V> data) {
        this.data = data;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public V get(Class key) {
        return (V)this.data.get((Object)this.key0(key));
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Collection<V> values() {
        return this.data.values();
    }

    public boolean containsEntry(Class type, V value) {
        String key = this.key0(type);
        return this.data.containsKey((Object)key) && this.data.values().contains(value);
    }

    private String key0(Class type) {
        return keyFunction.apply(type);
    }

    public static class Builder<V> {
        private final ImmutableMap.Builder<String, V> data = ImmutableMap.builder();

        private Builder() {
        }

        public Builder put(Class type, V value) {
            this.data.put(keyFunction.apply(type), value);
            return this;
        }

        public ImmutableDtoMap<V> build() {
            return new ImmutableDtoMap(this.data.build());
        }
    }
}

