/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.reference;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import fr.ird.observe.dto.ObserveDto;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class DtoReferenceCollection<R extends DtoReference>
implements ObserveDto,
Serializable {
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_REFERENCES = "references";
    private static final long serialVersionUID = 1L;
    final Class<R> type;
    private final List<R> references;

    DtoReferenceCollection(Class<R> type, List<R> references) {
        this.type = type;
        this.references = references;
    }

    public static <R extends ReferentialDtoReference> List<R> filterEnabled(Collection<R> references) {
        return references.stream().filter(ReferentialDtoReference::isEnabled).collect(Collectors.toList());
    }

    public static <R extends ReferentialDtoReference> List<R> filterContains(Collection<R> references, Set<String> containsIds) {
        return references.stream().filter(r -> containsIds.contains(r.getId())).collect(Collectors.toList());
    }

    public static <R extends ReferentialDtoReference> List<R> filterNotContains(Collection<R> references, Set<String> containsIds) {
        return references.stream().filter(r -> !containsIds.contains(r.getId())).collect(Collectors.toList());
    }

    public Class<R> getType() {
        return this.type;
    }

    public Optional<R> tryGetReferenceById(String id) {
        return this.references.stream().filter(DtoReference.newIdPredicate(id)).findFirst();
    }

    public R getReferenceByPosition(int index) {
        return (R)((DtoReference)Iterables.get(this.references, (int)index));
    }

    public int size() {
        return this.references.size();
    }

    public Set<R> toSet() {
        return ImmutableSet.copyOf(this.references);
    }

    public List<R> toList() {
        return ImmutableList.copyOf(this.references);
    }
}

