/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.form;

import com.google.common.base.MoreObjects;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.ObserveDto;
import fr.ird.observe.dto.form.FormDefinition;
import fr.ird.observe.spi.DtoModelHelper;
import java.io.Serializable;
import java.util.Optional;

public class Form<R extends IdDto>
implements ObserveDto,
Serializable {
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_OBJECT = "object";
    private static final long serialVersionUID = 1L;
    private final Class<R> type;
    private final R object;
    private FormDefinition<R> definition;

    public static <R extends IdDto> Form<R> newFormDto(Class<R> type, R object) {
        return new Form<R>(type, object);
    }

    protected Form(Class<R> type, R object) {
        this.type = type;
        this.object = object;
    }

    public R getObject() {
        return this.object;
    }

    public Class<R> getType() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(PROPERTY_TYPE, (Object)this.type.getName()).toString();
    }

    public Optional<FormDefinition<R>> getDefinition() {
        if (this.definition == null) {
            this.definition = DtoModelHelper.getOptionalFormDefinition(this.type).orElse(null);
        }
        return Optional.ofNullable(this.definition);
    }
}

