/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto;

import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.reference.DtoReference;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public class IdHelper {
    private static final String DTO_ROOT_PACKAGE = "fr.ird.observe.dto";
    private static final int DTO_ROOT_PACKAGE_LENGTH = "fr.ird.observe.dto".length() + 1;
    private static final String DTO_REFERENTIAL_PACKAGE = "fr.ird.observe.dto.referential";
    private static final String DTO_REFERENTIAL_SEINE_PACKAGE = "fr.ird.observe.dto.referential.seine";
    private static final String DTO_REFERENTIAL_LONGLINE_PACKAGE = "fr.ird.observe.dto.referential.longline";
    private static final String DTO_DATA_PACKAGE = "fr.ird.observe.dto.data";
    private static final String DTO_DATA_SEINE_PACKAGE = "fr.ird.observe.dto.data.seine";
    private static final String DTO_DATA_LONGLINE_PACKAGE = "fr.ird.observe.dto.data.longline";
    private static final String ENTITY_ROOT_PACKAGE = "fr.ird.observe.entities";
    private static final int ENTITY_ROOT_PACKAGE_LENGTH = "fr.ird.observe.entities".length() + 1;
    private static final String ENTITY_REFERENTIAL_PACKAGE = "fr.ird.observe.entities.referentiel";
    private static final String ENTITY_REFERENTIAL_SEINE_PACKAGE = "fr.ird.observe.entities.referentiel.seine";
    private static final String ENTITY_REFERENTIAL_LONGLINE_PACKAGE = "fr.ird.observe.entities.referentiel.longline";
    private static final String ENTITY_DATA_PACKAGE = "fr.ird.observe.entities";
    private static final String ENTITY_DATA_SEINE_PACKAGE = "fr.ird.observe.entities.seine";
    private static final String ENTITY_DATA_LONGLINE_PACKAGE = "fr.ird.observe.entities.longline";

    public static boolean isReferential(Class type) {
        return IdHelper.isReferentialFromPackageName(type.getPackage().getName());
    }

    public static boolean isReferentialFromPackageName(String packageName) {
        return packageName.startsWith(DTO_REFERENTIAL_PACKAGE);
    }

    public static boolean isReferentialFromClassName(String packageName) {
        return packageName.startsWith(DTO_REFERENTIAL_PACKAGE);
    }

    public static boolean isReferentialSeineFromPackageName(String packageName) {
        return DTO_REFERENTIAL_SEINE_PACKAGE.equals(packageName);
    }

    public static boolean isReferentialLonglineFromPackageName(String packageName) {
        return DTO_REFERENTIAL_LONGLINE_PACKAGE.equals(packageName);
    }

    public static boolean isReferentialSeineFromClassName(String packageName) {
        return DTO_REFERENTIAL_SEINE_PACKAGE.startsWith(packageName);
    }

    public static boolean isReferentialLonglineFromClassName(String packageName) {
        return DTO_REFERENTIAL_LONGLINE_PACKAGE.startsWith(packageName);
    }

    public static boolean isData(Class type) {
        return IdHelper.isDataFromPackageName(type.getPackage().getName());
    }

    public static boolean isDataFromPackageName(String packageName) {
        return packageName.startsWith(DTO_DATA_PACKAGE);
    }

    public static boolean isDataSeineFromPackageName(String packageName) {
        return DTO_DATA_SEINE_PACKAGE.equals(packageName);
    }

    public static boolean isDataLonglineFromPackageName(String packageName) {
        return DTO_DATA_LONGLINE_PACKAGE.equals(packageName);
    }

    public static boolean isDataFromClassName(String className) {
        return DTO_DATA_PACKAGE.startsWith(className);
    }

    public static boolean isDataSeineFromClassName(String className) {
        return DTO_DATA_SEINE_PACKAGE.startsWith(className);
    }

    public static boolean isDataLonglineFromClassName(String className) {
        return DTO_DATA_LONGLINE_PACKAGE.startsWith(className);
    }

    public static String getDtoSimplifiedName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return IdHelper.cleanId(dataType.getName().substring(DTO_ROOT_PACKAGE_LENGTH));
    }

    public static String getEntitySimplifiedName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return IdHelper.cleanId(dataType.getName().substring(ENTITY_ROOT_PACKAGE_LENGTH));
    }

    public static String getEntitySimplifiedName(String dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return IdHelper.cleanId(dataType.substring(ENTITY_ROOT_PACKAGE_LENGTH));
    }

    public static String getDtoShortName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return IdHelper.cleanId(dataType);
    }

    public static String cleanId(Class id) {
        return IdHelper.cleanId(id.getSimpleName());
    }

    public static boolean equalsCleanId(Class one, Class two) {
        return IdHelper.cleanId(one.getSimpleName()).equals(IdHelper.cleanId(two.getSimpleName()));
    }

    public static String cleanId(String id) {
        if (id.endsWith("Dto")) {
            return id.substring(0, id.length() - 3);
        }
        if (id.endsWith("Reference")) {
            return id.substring(0, id.length() - 9);
        }
        int index = id.indexOf("_");
        if (index > -1) {
            id = id.substring(0, index);
        } else {
            index = id.indexOf("@");
            if (index > -1) {
                id = id.substring(0, index);
            }
        }
        if (id.endsWith("Impl")) {
            return id.substring(0, id.length() - 4);
        }
        return id;
    }

    public static <BeanType extends IdDto> BeanType findById(Collection<BeanType> source, String id) {
        return (BeanType)((IdDto)source.stream().filter(IdHelper.newIdPredicate(id)::test).findFirst().orElse(null));
    }

    public static <BeanType extends IdDto> boolean exists(Collection<BeanType> source, String id) {
        return source.stream().anyMatch(IdHelper.newIdPredicate(id)::test);
    }

    public static boolean isProgramId(String id) {
        return id.contains("Program");
    }

    public static boolean isTrip(IdDto dto) {
        return IdHelper.isTripSeineId(dto.getId()) || IdHelper.isTripLonglineId(dto.getId());
    }

    public static boolean isTrip(DtoReference dto) {
        return IdHelper.isTripSeineId(dto.getId()) || IdHelper.isTripLonglineId(dto.getId());
    }

    public static boolean isTripLonglineId(String id) {
        return id.contains("TripLongline");
    }

    public static boolean isTripSeineId(String id) {
        return id.contains("TripSeine");
    }

    public static boolean isRouteId(String id) {
        return id.contains("Route");
    }

    public static boolean isActivitySeine(IdDto dto) {
        return IdHelper.isActivitySeineId(dto.getId());
    }

    public static boolean isActivitySeineId(String id) {
        return id.contains("ActivitySeine");
    }

    public static boolean isActivityLongline(IdDto dto) {
        return IdHelper.isActivityLonglineId(dto.getId());
    }

    public static boolean isActivityLonglineId(String id) {
        return id.contains("ActivityLongline");
    }

    public static boolean isSetSeine(IdDto dto) {
        return IdHelper.isSetSeineId(dto.getId());
    }

    public static boolean isSetSeineId(String id) {
        return id.contains("SetSeine");
    }

    public static boolean isSetLongline(IdDto dto) {
        return IdHelper.isSetLonglineId(dto.getId());
    }

    public static boolean isSetLonglineId(String id) {
        return id.contains("SetLongline");
    }

    public static boolean isFloatingObject(IdDto dto) {
        return IdHelper.isFloatingObjectId(dto.getId());
    }

    public static boolean isFloatingObjectId(String id) {
        return id.contains("FloatingObject");
    }

    public static boolean isSeineId(String id) {
        return id.contains("Seine");
    }

    public static boolean isLonglineId(String id) {
        return id.contains("Longline");
    }

    public static <BeanType extends IdDto> Predicate<BeanType> newIdPredicate(String id) {
        return o -> Objects.equals(id, o.getId());
    }
}

