/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.referential;

import fr.ird.observe.dto.referential.WithFormula;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.NumberUtil;

public class FormulaHelper {
    private static final Log log = LogFactory.getLog(FormulaHelper.class);
    private static final Pattern COEFFICIENTS_PATTERN = Pattern.compile("(.+)=(.+)");
    public static final String VARIABLE_WEIGHT = "P";
    public static final String VARIABLE_LENGTH = "L";
    private static final String VARIABLE_X = "x";
    public static final String VARIABLE_INPUT = "I";
    public static final String VARIABLE_OUTPUT = "O";
    public static final String COEFFICIENT_A = "a";
    public static final String COEFFICIENT_B = "b";
    private static ScriptEngine scriptEngine;

    private static ScriptEngine getScriptEngine() {
        if (scriptEngine == null) {
            ScriptEngineManager factory = new ScriptEngineManager();
            scriptEngine = factory.getEngineByExtension("js");
        }
        return scriptEngine;
    }

    public static Map<String, Double> getCoefficientValues(WithFormula parametrage) {
        TreeMap<String, Double> result = new TreeMap<String, Double>();
        String coefficients = parametrage.getCoefficients();
        if (coefficients != null) {
            for (String coefficientDef : coefficients.split(":")) {
                Matcher matcher = COEFFICIENTS_PATTERN.matcher(coefficientDef.trim());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("constant to test = " + coefficientDef));
                }
                if (!matcher.matches()) continue;
                String key = matcher.group(1);
                String val = matcher.group(2);
                try {
                    Double d = Double.valueOf(val);
                    result.put(key, d);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("detects coefficient " + key + '=' + val));
                }
                catch (NumberFormatException e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("could not parse double " + val + " for coefficient " + key));
                }
            }
        }
        return result;
    }

    public static boolean validateRelation(WithFormula parametrage, String relation, String variable) {
        boolean result;
        block4: {
            result = false;
            if (!StringUtils.isEmpty((CharSequence)relation)) {
                Map<String, Double> coeffs = parametrage.getCoefficientValues();
                ScriptEngine engine = FormulaHelper.getScriptEngine();
                Bindings bindings = engine.createBindings();
                FormulaHelper.addBindings(coeffs, bindings, variable, 1.0f);
                try {
                    engine.setBindings(bindings, 100);
                    Double o = (Double)engine.eval("parseFloat(" + relation + ")");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("evaluation ok : " + relation + " (" + variable + "=1) = " + o));
                    }
                    result = true;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)("evaluation ko : " + relation + ", reason : " + e.getMessage()));
                }
            }
        }
        return result;
    }

    public static boolean validateObjectMaterialValidation(String relation, Object value) {
        boolean result;
        block4: {
            result = false;
            if (!StringUtils.isEmpty((CharSequence)relation)) {
                ScriptEngine engine = FormulaHelper.getScriptEngine();
                Bindings bindings = engine.createBindings();
                bindings.put(VARIABLE_X, value);
                try {
                    engine.setBindings(bindings, 100);
                    Boolean o = (Boolean)engine.eval(relation);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("evaluation ok : %s (%s=%s) = %s", relation, VARIABLE_X, value, o));
                    }
                    result = o != null && o != false;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)("evaluation ko : " + relation + ", reason : " + e.getMessage()));
                }
            }
        }
        return result;
    }

    public static Float computeValue(WithFormula parametrage, String formula, String coefficientName, String variableName, float data) {
        Double b;
        if (coefficientName != null && (b = parametrage.getCoefficientValue(coefficientName)) == 0.0) {
            return null;
        }
        Float o = FormulaHelper.computeValue(parametrage, formula, variableName, data);
        if (o != null) {
            o = NumberUtil.roundOneDigit((Float)o);
        }
        return o;
    }

    private static Float computeValue(WithFormula parametrage, String relation, String variable, float taille) {
        Double o;
        block2: {
            Map<String, Double> coeffs = parametrage.getCoefficientValues();
            ScriptEngine engine = FormulaHelper.getScriptEngine();
            Bindings bindings = engine.createBindings();
            FormulaHelper.addBindings(coeffs, bindings, variable, taille);
            engine.setBindings(bindings, 100);
            o = null;
            try {
                o = (Double)engine.eval("parseFloat(" + relation + ")");
            }
            catch (ScriptException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Could not compute value from " + relation));
            }
        }
        return o == null ? null : Float.valueOf(o.floatValue());
    }

    private static void addBindings(Map<String, Double> coeffs, Bindings bindings, String variable, float taille) {
        for (Map.Entry<String, Double> entry : coeffs.entrySet()) {
            String key = entry.getKey();
            Double value = entry.getValue();
            bindings.put(key, (Object)value);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("add constant " + key + '=' + value));
        }
        bindings.put(variable, (Object)Float.valueOf(taille));
    }
}

