/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdHelper;
import fr.ird.observe.dto.ObserveDto;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class ImmutableSetMap<V>
implements ObserveDto {
    static final transient Function<Class, String> keyFunction = IdHelper::getDtoSimplifiedName;
    private final ImmutableMap<String, Set<V>> data;
    private final ImmutableMap<String, Class> types;

    ImmutableSetMap(ImmutableMap<String, Set<V>> data, ImmutableMap<String, Class> types) {
        this.data = data;
        this.types = types;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Set<V> get(Class key) {
        return (Set)this.data.get((Object)this.key0(key));
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Collection<Set<V>> values() {
        return this.data.values();
    }

    public boolean containsEntry(Class type, V value) {
        String key = this.key0(type);
        return this.data.containsKey((Object)key) && ((Set)this.data.get((Object)key)).contains(value);
    }

    public Set<Class<? extends ReferentialDtoReference>> referentialReferenceTypes() {
        return this.types.values().stream().filter(IdHelper::isReferential).collect(Collectors.toSet());
    }

    public Set<Class<? extends DataDtoReference>> dataReferenceTypes() {
        return this.types.values().stream().filter(IdHelper::isData).collect(Collectors.toSet());
    }

    public ImmutableMap<String, Set<V>> getData() {
        return this.data;
    }

    public ImmutableMap<String, Class> getTypes() {
        return this.types;
    }

    private String key0(Class type) {
        return keyFunction.apply(type);
    }
}

