/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.form;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceDefinition;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.spi.DtoModelHelper;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;
import fr.ird.observe.spi.map.ImmutableDtoMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FormDefinition<D extends IdDto> {
    private final Class<D> type;
    private final ImmutableMap<String, ReferentialDtoReferenceDefinition<?, ?>> properties;

    public static <D extends IdDto> Builder<D> builder(Class<D> type) {
        return new Builder<D>(type, DtoModelHelper.getReferencesInitializer());
    }

    public ImmutableMap<String, ReferentialDtoReferenceDefinition<?, ?>> getProperties() {
        return this.properties;
    }

    FormDefinition(Class<D> type, ImmutableMap<String, ReferentialDtoReferenceDefinition<?, ?>> properties) {
        this.type = type;
        this.properties = properties;
    }

    public Class<D> getType() {
        return this.type;
    }

    public Set<Class<?>> getPropertiesTypes() {
        return this.properties.values().stream().map(DtoReferenceDefinition::getDtoType).collect(Collectors.toSet());
    }

    public Set<Class<?>> getPropertiesReferenceTypes() {
        return this.properties.values().stream().map(DtoReferenceDefinition::getType).collect(Collectors.toSet());
    }

    public static class Builder<D extends IdDto> {
        private final Class<D> type;
        private final DtoReferencesInitializerSupport referencesInitializer;
        private final ImmutableMap.Builder<String, ReferentialDtoReferenceDefinition<?, ?>> propertiesBuilder;

        public Builder(Class<D> type, DtoReferencesInitializerSupport referencesInitializer) {
            this.type = type;
            this.referencesInitializer = referencesInitializer;
            this.propertiesBuilder = ImmutableMap.builder();
        }

        public FormDefinition<D> build(ImmutableDtoMap.Builder<FormDefinition<? extends IdDto>> formDefinitionBuilder) {
            FormDefinition<D> definition = new FormDefinition<D>(this.type, this.propertiesBuilder.build());
            formDefinitionBuilder.put(this.type, definition);
            return definition;
        }

        public <DD extends ReferentialDto, RR extends ReferentialDtoReference<DD, RR>> Builder<D> addProperty(String name, Class<RR> referenceType) {
            ReferentialDtoReferenceDefinition<DD, RR> definition = this.referenceSetDefinition(referenceType);
            this.propertiesBuilder.put((Object)name, definition);
            return this;
        }

        private <DD extends ReferentialDto, R extends ReferentialDtoReference<DD, R>> ReferentialDtoReferenceDefinition<DD, R> referenceSetDefinition(Class<R> referenceType) {
            ReferentialDtoReferenceDefinition referenceDefinition = this.referencesInitializer.getReferentialReferenceSetDefinition().get(referenceType);
            Objects.requireNonNull(referenceDefinition, "Could not find referenceSet for type: " + referenceType);
            return referenceDefinition;
        }
    }
}

