/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto;

import fr.ird.observe.dto.CoordinateHelper;
import java.io.Serializable;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.util.DateUtil;

public class GPSPoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(GPSPoint.class);
    private static final double MILE_TO_KM = 1.852;
    private static final double EARTH_RADIUS = 3958.75;
    public static final int R = 6378;
    protected Float latitude;
    protected Float longitude;
    protected Float vitesse;
    protected Date time;

    public static GPSPoint newPoint(Date routeDay, Date activityTime, float activityLatitude, float activityLongitude) {
        Date currentTime = DateUtil.getDateAndTime((Date)routeDay, (Date)activityTime, (boolean)false, (boolean)false);
        GPSPoint gpsPoint = new GPSPoint();
        gpsPoint.setTime(currentTime);
        gpsPoint.setLatitude(Float.valueOf(activityLatitude));
        gpsPoint.setLongitude(Float.valueOf(activityLongitude));
        return gpsPoint;
    }

    public Integer getQuadrant() {
        return CoordinateHelper.getQuadrant(this.longitude, this.latitude);
    }

    private boolean isSameLocation(GPSPoint point) {
        float latitude = this.getLatitude() == null ? 0.0f : this.getLatitude().floatValue();
        float longitude = this.getLongitude() == null ? 0.0f : this.getLongitude().floatValue();
        float latitude1 = point.getLatitude() == null ? 0.0f : point.getLatitude().floatValue();
        float longitude1 = point.getLongitude() == null ? 0.0f : point.getLongitude().floatValue();
        return latitude == latitude1 && longitude == longitude1;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }

    public Float getVitesse() {
        return this.vitesse;
    }

    public void setVitesse(Float vitesse) {
        this.vitesse = vitesse;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public double getDistanceInKm(GPSPoint p1) {
        return this.getDistanceInMile(p1) * 1.852;
    }

    private double getDistanceInMile(GPSPoint p1) {
        double d;
        if (this.isSameLocation(p1)) {
            d = 0.0;
        } else {
            double lat1 = this.latitude.floatValue();
            double lng1 = this.longitude.floatValue();
            double lat2 = p1.getLatitude().floatValue();
            double lng2 = p1.getLongitude().floatValue();
            double dLat = Math.toRadians(lat2 - lat1);
            double dLng = Math.toRadians(lng2 - lng1);
            double sindLat = Math.sin(dLat / 2.0);
            double sindLng = Math.sin(dLng / 2.0);
            double a = Math.pow(sindLat, 2.0) + Math.pow(sindLng, 2.0) * Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2));
            double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            d = 3958.75 * c;
        }
        return d;
    }

    public float getSpeed(GPSPoint p1) {
        if (this.time.after(p1.getTime())) {
            if (log.isWarnEnabled()) {
                log.warn("Le point " + this + " est chronologiquement apr\u00e8s le point " + p1 + " impossible de calculer une vitesse.");
            }
            return 0.0f;
        }
        double d = this.getDistanceInMile(p1);
        float delay = (float)this.getDelay(p1) / 3600000.0f;
        double speed = d / (double)delay;
        return (float)speed;
    }

    private long getDelay(GPSPoint p1) {
        long d0 = this.getTime().getTime();
        long d1 = p1.getTime().getTime();
        return d1 - d0;
    }
}

