package fr.ird.observe.spi.initializer;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.form.FormDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.spi.DtoModelHelper;
import fr.ird.observe.spi.map.DtoToDtoClassMap;
import fr.ird.observe.spi.map.ImmutableDtoMap;

/**
 * Created by tchemit on 28/08/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class DtoFormsInitializerSupport {

    private final ImmutableMap.Builder<Class, Class> dtoToFormClassMappingBuilder = ImmutableMap.builder();
    protected final ImmutableDtoMap.Builder<FormDefinition<? extends IdDto>> formDefinitionsBuilder = ImmutableDtoMap.builder();

    private ImmutableDtoMap<FormDefinition<? extends IdDto>> formDefinitions;
    private DtoToDtoClassMap dtoToFormClassMapping;

    protected DtoFormsInitializerSupport() {
    }

    protected <D extends IdDto> FormDefinition.Builder<D> formBuilder(Class<D> type) {
        return new FormDefinition.Builder<>(type, DtoModelHelper.getReferencesInitializer());
    }

    protected <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> FormDefinition.Builder<D> referentialFormBuilder(Class<D> dtoType) {
        DtoReferencesInitializerSupport referencesInitializer = DtoModelHelper.getReferencesInitializer();
        Class<R> referenceType = referencesInitializer.getDtoToReferenceClassMapping().forReferential(dtoType);
        FormDefinition.Builder<D> dBuilder = new FormDefinition.Builder<>(dtoType, referencesInitializer);
        return dBuilder.addProperty("referentialListHeader", referenceType);
    }

    protected <D extends IdDto, F extends IdDto> void addClassMapping(Class<D> dtoType, Class<F> formType) {
        dtoToFormClassMappingBuilder.put(dtoType, formType);
    }

    public void end() {
        dtoToFormClassMapping = new DtoToDtoClassMap(dtoToFormClassMappingBuilder.build());
        formDefinitions = formDefinitionsBuilder.build();
    }

    public ImmutableDtoMap<FormDefinition<? extends IdDto>> getFormDefinitions() {
        return formDefinitions;
    }

    public DtoToDtoClassMap getDtoToFormClassMapping() {
        return dtoToFormClassMapping;
    }
}
