package fr.ird.observe.spi.context;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.binder.referential.ReferentialDtoReferenceBinder;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceDefinition;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;

/**
 * Created by tchemit on 03/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
@SuppressWarnings("unchecked")
public class ReferentialReferenceContext<D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> {

    private final Class<R> referenceType;
    private final Class<D> dtoType;
    private final ReferentialDtoReferenceBinder<D, R> referenceBinder;
    private final ReferentialDtoReferenceDefinition<D, R> referenceDefinition;

    ReferentialReferenceContext(Class<R> referenceType, DtoReferencesInitializerSupport modelHelper) {
        this.referenceType=referenceType;
        this.dtoType = modelHelper.getReferenceToDtoClassMapping().forReferential(referenceType);
        this.referenceBinder = modelHelper.getReferentialBinders().get(referenceType);
        this.referenceDefinition = modelHelper.getReferentialReferenceSetDefinition().get(referenceType);
    }

    public Class<D> toDtoType() {
        return dtoType;
    }

    public ReferentialDtoReferenceBinder<D, R> toReferenceBinder() {
        return referenceBinder;
    }

    public DtoReferenceDefinition<D, R> toReferenceDefinition() {
        return referenceDefinition;
    }

    public Class<R> toReferenceType() {
        return referenceType;
    }
}
