package fr.ird.observe.spi.context;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */


import fr.ird.observe.binder.data.DataDtoReferenceBinder;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DataDtoReferenceDefinition;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;

/**
 * Created by tchemit on 03/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
@SuppressWarnings("unchecked")
public class DataReferenceContext<D extends DataDto, R extends DataDtoReference<D, R>> {

    private final Class<D> dtoType;
    private final DataDtoReferenceBinder<D, R> referenceBinder;
    private final DataDtoReferenceDefinition<D, R> referenceDefinition;
    private final Class<R> referenceType;

    DataReferenceContext(Class<R> referenceType, DtoReferencesInitializerSupport modelHelper) {
        this.referenceType = referenceType;
        this.dtoType = modelHelper.getReferenceToDtoClassMapping().forData(referenceType);
        this.referenceBinder = modelHelper.getDataBinders().get(referenceType);
        this.referenceDefinition = modelHelper.getDataReferenceSetDefinition().get(referenceType);
    }

    public Class<R> toReferenceType() {
        return referenceType;
    }

    public Class<D> toDtoType() {
        return dtoType;
    }

    public DataDtoReferenceBinder<D, R> toReferenceBinder() {
        return referenceBinder;
    }

    public DtoReferenceDefinition<D, R> toReferenceDefinition() {
        return referenceDefinition;
    }
}
