package fr.ird.observe.spi.context;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.binder.data.DataDtoReferenceBinder;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.dto.referential.ReferentialLocale;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;

/**
 * Created by tchemit on 03/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
@SuppressWarnings("unchecked")
public class DataDtoContext<D extends DataDto, R extends DataDtoReference<D, R>> {

    private final Class<D> dtoType;
    private final Class<R> referenceType;
    private final DataDtoReferenceBinder<D, R> referenceBinder;
    private final DtoReferenceDefinition<D, R> referenceDefinition;

    public DataDtoContext(Class<D> dtoType, DtoReferencesInitializerSupport modelHelper) {
        this.dtoType = dtoType;
        this.referenceType = modelHelper.getDtoToReferenceClassMapping().forData(dtoType);
        this.referenceBinder = modelHelper.getDataBinders().get(dtoType);
        this.referenceDefinition = modelHelper.getDataReferenceSetDefinition().get(dtoType);
    }

    public Class<D> toDtoType() {
        return dtoType;
    }

    public <RR extends DataDtoReference<D, RR>> Class<RR> toReferenceType() {
        return (Class<RR>) referenceType;
    }

    public <RR extends DataDtoReference<D, RR>> DataDtoReferenceBinder<D, RR> toReferenceBinder() {
        return (DataDtoReferenceBinder<D, RR>) referenceBinder;
    }

    public <RR extends DataDtoReference<D, RR>> DtoReferenceDefinition<D, RR> toReferenceDefinition() {
        return (DtoReferenceDefinition<D, RR>) referenceDefinition;
    }

    public <RR extends DataDtoReference<D, RR>> RR toReference(ReferentialLocale referentialLocale, D dto) {
        return (RR) referenceBinder.toReference(referentialLocale, dto);
    }
}
