package fr.ird.observe.dto.referential;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

public abstract class I18nReferentialDto extends ReferentialDto {

    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_LABEL1 = "label1";

    public static final String PROPERTY_LABEL2 = "label2";

    public static final String PROPERTY_LABEL3 = "label3";

    public static final String PROPERTY_LABEL4 = "label4";

    public static final String PROPERTY_LABEL5 = "label5";

    public static final String PROPERTY_LABEL6 = "label6";

    public static final String PROPERTY_LABEL7 = "label7";

    public static final String PROPERTY_LABEL8 = "label8";

    private static final long serialVersionUID = 3832622876506665573L;

    protected String label1;

    protected String label2;

    protected String label3;

    protected String label4;

    protected String label5;

    protected String label6;

    protected String label7;

    protected String label8;

    public String getLabel1() {
        return label1;
    }

    public void setLabel1(String label1) {
        String oldValue = getLabel1();
        this.label1 = label1;
        firePropertyChange(PROPERTY_LABEL1, oldValue, label1);
    }

    public String getLabel2() {
        return label2;
    }

    public void setLabel2(String label2) {
        String oldValue = getLabel2();
        this.label2 = label2;
        firePropertyChange(PROPERTY_LABEL2, oldValue, label2);
    }

    public String getLabel3() {
        return label3;
    }

    public void setLabel3(String label3) {
        String oldValue = getLabel3();
        this.label3 = label3;
        firePropertyChange(PROPERTY_LABEL3, oldValue, label3);
    }

    public String getLabel4() {
        return label4;
    }

    public void setLabel4(String label4) {
        String oldValue = getLabel4();
        this.label4 = label4;
        firePropertyChange(PROPERTY_LABEL4, oldValue, label4);
    }

    public String getLabel5() {
        return label5;
    }

    public void setLabel5(String label5) {
        String oldValue = getLabel5();
        this.label5 = label5;
        firePropertyChange(PROPERTY_LABEL5, oldValue, label5);
    }

    public String getLabel6() {
        return label6;
    }

    public void setLabel6(String label6) {
        String oldValue = getLabel6();
        this.label6 = label6;
        firePropertyChange(PROPERTY_LABEL6, oldValue, label6);
    }

    public String getLabel7() {
        return label7;
    }

    public void setLabel7(String label7) {
        String oldValue = getLabel7();
        this.label7 = label7;
        firePropertyChange(PROPERTY_LABEL7, oldValue, label7);
    }

    public String getLabel8() {
        return label8;
    }

    public void setLabel8(String label8) {
        String oldValue = getLabel8();
        this.label8 = label8;
        firePropertyChange(PROPERTY_LABEL8, oldValue, label8);
    }

    public String getLabel(ReferentialLocale referentialLocale) {
        return I18nReferentialHelper.decorate(referentialLocale.ordinal(), this);
    }
}
