package fr.ird.observe.dto.reference;

/*
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ReferentialDtoReferenceSet<R extends ReferentialDtoReference> extends DtoReferenceCollection<R> {

    public static final String PROPERTY_LAST_UPDATE = "lastUpdate";

    private static final long serialVersionUID = 1L;

    private Date lastUpdate;

    public static <R extends ReferentialDtoReference> ReferentialDtoReferenceSet<R> of(Class<R> type,
                                                                                       Collection<R> references,
                                                                                       Date lastUpdate) {

        return new ReferentialDtoReferenceSet<>(type, references instanceof List ? (List<R>) references : new ArrayList<>(references), lastUpdate);

    }

    protected ReferentialDtoReferenceSet(Class<R> type, List<R> references, Date lastUpdate) {
        super(type, references);
        this.lastUpdate = lastUpdate;
    }

    public Date getLastUpdate() {
        return lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add(PROPERTY_TYPE, type.getName())
                .add(PROPERTY_LAST_UPDATE, lastUpdate)
                .toString();
    }
}
