package fr.ird.observe.dto.reference;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.MoreObjects;
import fr.ird.observe.dto.referential.ReferentialDto;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

/**
 * Created on 21/11/15.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class ReferentialDtoReference<D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> extends DtoReference<D, R> implements ReferentialDtoReferenceAware {

    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_CODE = "code";

    /** Logger. */
    private static final Logger log = LogManager.getLogger(ReferentialDtoReference.class);

    private final boolean needComment;
    private final boolean enabled;

    protected ReferentialDtoReference(ReferentialDtoReferenceAware dto) {
        super(dto);
        this.enabled = dto.isEnabled();
        this.needComment = dto.isNeedComment();
    }

    @Override
    public boolean isNeedComment() {
        return needComment;
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this)
                .add(PROPERTY_TYPE, getDtoType().getSimpleName())
                .add(ReferentialDto.PROPERTY_ID, getId());

        if (log.isDebugEnabled()) {
            toStringHelper
                    .add(PROPERTY_ENABLED, enabled)
                    .add(ReferentialDto.PROPERTY_NEED_COMMENT, needComment)
                    .add(ReferentialDto.PROPERTY_CREATE_DATE, getCreateDate())
                    .add(ReferentialDto.PROPERTY_LAST_UPDATE_DATE, getLastUpdateDate())
                    .add(ReferentialDto.PROPERTY_VERSION, getVersion());
//                    .add(PROPERTY_LABEL_PROPERTY_VALUES, labelPropertyNames);
        }
        return toStringHelper
//                .add(PROPERTY_LABEL_PROPERTY_VALUES, Arrays.toString(labelPropertyValues))
                .toString();
    }

}
