package fr.ird.observe.dto.reference;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.MoreObjects;
import fr.ird.observe.dto.data.DataDto;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

/**
 * Created on 21/11/15.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class DataDtoReference<D extends DataDto, R extends DataDtoReference<D, R>> extends DtoReference<D, R> {

    /** Logger. */
    private static final Logger log = LogManager.getLogger(DataDtoReference.class);

    protected DataDtoReference(DtoReferenceAware dto) {
        super(dto);
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this)
                .add(PROPERTY_TYPE, getDtoType().getSimpleName())
                .add(DataDto.PROPERTY_ID, getId())
                .add(DataDto.PROPERTY_LAST_UPDATE_DATE, getLastUpdateDate());

        if (log.isDebugEnabled()) {
            toStringHelper
                    .add(PROPERTY_CREATE_DATE, getCreateDate())
                    .add(PROPERTY_VERSION, getVersion())
                    .add(PROPERTY_CREATE_DATE, getDefinition().getPropertyNames());
        }
        return toStringHelper
//                .add(PROPERTY_LABEL_PROPERTY_VALUES, Arrays.toString(labelPropertyValues))
                .toString();
    }

}
