package fr.ird.observe.dto.data;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.dto.IdHelper;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class DataHelper extends IdHelper {

    public static <BeanType extends DataDto> Class<BeanType> typeOfDataDto() {
        return (Class<BeanType>) DataDto.class;
    }

    public static <BeanType extends DataDto> void copyDataDto(BeanType source, BeanType target) {
        Class<BeanType> sourceType = typeOfDataDto();
        Binder<BeanType, BeanType> binder = BinderFactory.newBinder(sourceType);
        binder.copy(source, target);
    }

    public static <BeanType extends DataDto> void copyDataDto(BeanType source, BeanType target, Binder<BeanType, BeanType> binder) {
        binder.copy(source, target);
    }

}
