/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.initializer;

import com.google.common.collect.ImmutableSet;
import fr.ird.observe.binder.data.DataDtoReferenceBinder;
import fr.ird.observe.binder.referential.ReferentialDtoReferenceBinder;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DataDtoReferenceDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceDefinition;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.spi.map.DtoToReferenceClassMap;
import fr.ird.observe.spi.map.ImmutableDtoMap;
import fr.ird.observe.spi.map.ReferenceToDtoClassMap;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class DtoReferencesInitializerSupport {
    private final ImmutableDtoMap.Builder<ReferentialDtoReferenceDefinition> referentialReferenceSetDefinitionBuilder = ImmutableDtoMap.builder();
    private final ImmutableDtoMap.Builder<DataDtoReferenceDefinition> dataReferenceSetDefinitionBuilder = ImmutableDtoMap.builder();
    private final Set<Class<? extends ReferentialDto>> referentialTypesBuilder = new LinkedHashSet<Class<? extends ReferentialDto>>();
    private final Set<Class<? extends DataDto>> dataTypesBuilder = new LinkedHashSet<Class<? extends DataDto>>();
    private final ImmutableDtoMap.Builder<Class> dtoToReferenceClassMappingBuilder = ImmutableDtoMap.builder();
    private final ImmutableDtoMap.Builder<Class> referenceToDtoClassMappingBuilder = ImmutableDtoMap.builder();
    private final ImmutableDtoMap.Builder<ReferentialDtoReferenceBinder> referentialBindersBuilder = ImmutableDtoMap.builder();
    private final ImmutableDtoMap.Builder<DataDtoReferenceBinder> dataBindersBuilder = ImmutableDtoMap.builder();
    private ImmutableDtoMap<ReferentialDtoReferenceDefinition> referentialReferenceSetDefinition;
    private ImmutableDtoMap<DataDtoReferenceDefinition> dataReferenceSetDefinition;
    private ImmutableSet<Class<? extends ReferentialDto>> referentialTypes;
    private ImmutableSet<Class<? extends DataDto>> dataTypes;
    private DtoToReferenceClassMap dtoToReferenceClassMapping;
    private ReferenceToDtoClassMap referenceToDtoClassMapping;
    private ImmutableDtoMap<ReferentialDtoReferenceBinder> referentialBinders;
    private ImmutableDtoMap<DataDtoReferenceBinder> dataBinders;

    public ImmutableDtoMap<ReferentialDtoReferenceDefinition> getReferentialReferenceSetDefinition() {
        return this.referentialReferenceSetDefinition;
    }

    public ImmutableDtoMap<DataDtoReferenceDefinition> getDataReferenceSetDefinition() {
        return this.dataReferenceSetDefinition;
    }

    public ImmutableSet<Class<? extends ReferentialDto>> getReferentialTypes() {
        return this.referentialTypes;
    }

    public ImmutableSet<Class<? extends DataDto>> getDataTypes() {
        return this.dataTypes;
    }

    public DtoToReferenceClassMap getDtoToReferenceClassMapping() {
        return this.dtoToReferenceClassMapping;
    }

    public ReferenceToDtoClassMap getReferenceToDtoClassMapping() {
        return this.referenceToDtoClassMapping;
    }

    public ImmutableDtoMap<ReferentialDtoReferenceBinder> getReferentialBinders() {
        return this.referentialBinders;
    }

    public ImmutableDtoMap<DataDtoReferenceBinder> getDataBinders() {
        return this.dataBinders;
    }

    public void end() {
        this.referentialReferenceSetDefinition = this.referentialReferenceSetDefinitionBuilder.build();
        this.dataReferenceSetDefinition = this.dataReferenceSetDefinitionBuilder.build();
        this.referentialTypes = ImmutableSet.copyOf(this.referentialTypesBuilder);
        this.dataTypes = ImmutableSet.copyOf(this.dataTypesBuilder);
        this.dtoToReferenceClassMapping = new DtoToReferenceClassMap(this.dtoToReferenceClassMappingBuilder.build());
        this.referenceToDtoClassMapping = new ReferenceToDtoClassMap(this.referenceToDtoClassMappingBuilder.build());
        this.referentialBinders = this.referentialBindersBuilder.build();
        this.dataBinders = this.dataBindersBuilder.build();
    }

    protected <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> void flushReferential(ReferentialDtoReferenceDefinition<D, R> result) {
        this.referentialTypesBuilder.add(result.getDtoType());
        this.referentialReferenceSetDefinitionBuilder.put(result.getType(), result);
        this.dtoToReferenceClassMappingBuilder.put(result.getDtoType(), result.getType());
        this.referenceToDtoClassMappingBuilder.put(result.getType(), result.getDtoType());
    }

    protected <D extends DataDto, R extends DataDtoReference<D, R>> void flushData(DataDtoReferenceDefinition<D, R> result) {
        this.dataTypesBuilder.add(result.getDtoType());
        this.dataReferenceSetDefinitionBuilder.put(result.getType(), result);
        this.dtoToReferenceClassMappingBuilder.put(result.getDtoType(), result.getType());
        this.referenceToDtoClassMappingBuilder.put(result.getType(), result.getDtoType());
    }

    protected <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>, B extends ReferentialDtoReferenceBinder<D, R>> void registerReferentialBinder(B binder) {
        this.referentialBindersBuilder.put(binder.getDtoType(), binder);
    }

    protected <D extends DataDto, R extends DataDtoReference<D, R>, B extends DataDtoReferenceBinder<D, R>> void registerDataBinder(B binder) {
        this.dataBindersBuilder.put(binder.getDtoType(), binder);
    }
}

