/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.context;

import fr.ird.observe.binder.data.DataDtoReferenceBinder;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.dto.referential.ReferentialLocale;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;

public class DataDtoContext<D extends DataDto, R extends DataDtoReference<D, R>> {
    private final Class<D> dtoType;
    private final Class<R> referenceType;
    private final DataDtoReferenceBinder<D, R> referenceBinder;
    private final DtoReferenceDefinition<D, R> referenceDefinition;

    public DataDtoContext(Class<D> dtoType, DtoReferencesInitializerSupport modelHelper) {
        this.dtoType = dtoType;
        this.referenceType = modelHelper.getDtoToReferenceClassMapping().forData(dtoType);
        this.referenceBinder = modelHelper.getDataBinders().get(dtoType);
        this.referenceDefinition = modelHelper.getDataReferenceSetDefinition().get(dtoType);
    }

    public Class<D> toDtoType() {
        return this.dtoType;
    }

    public <RR extends DataDtoReference<D, RR>> Class<RR> toReferenceType() {
        return this.referenceType;
    }

    public <RR extends DataDtoReference<D, RR>> DataDtoReferenceBinder<D, RR> toReferenceBinder() {
        return this.referenceBinder;
    }

    public <RR extends DataDtoReference<D, RR>> DtoReferenceDefinition<D, RR> toReferenceDefinition() {
        return this.referenceDefinition;
    }

    public <RR extends DataDtoReference<D, RR>> RR toReference(ReferentialLocale referentialLocale, D dto) {
        return (RR)((DataDtoReference)this.referenceBinder.toReference(referentialLocale, dto));
    }
}

