package fr.ird.observe.dto.referential;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2018 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class I18nReferentialHelper {

    public static <E extends I18nReferentialDto> String decorate(int referenceLocaleOrdinal, E i18nDto) {

        String result = null;

        switch (referenceLocaleOrdinal + 1) {
            case 1:
                result = i18nDto.getLabel1();
                break;
            case 2:
                result = i18nDto.getLabel2();
                break;
            case 3:
                result = i18nDto.getLabel3();
                break;
            case 4:
                result = i18nDto.getLabel4();
                break;
            case 5:
                result = i18nDto.getLabel5();
                break;
            case 6:
                result = i18nDto.getLabel6();
                break;
            case 7:
                result = i18nDto.getLabel7();
                break;
            case 8:
                result = i18nDto.getLabel8();
                break;
        }

        return result;

    }


    public static final Function<I18nReferentialDto, String> LABEL1_FUNCTION = I18nReferentialDto::getLabel1;

    public static final Function<I18nReferentialDto, String> LABEL2_FUNCTION = I18nReferentialDto::getLabel2;

    public static final Function<I18nReferentialDto, String> LABEL3_FUNCTION = I18nReferentialDto::getLabel3;

    public static final Function<I18nReferentialDto, String> LABEL4_FUNCTION = I18nReferentialDto::getLabel4;

    public static final Function<I18nReferentialDto, String> LABEL5_FUNCTION = I18nReferentialDto::getLabel5;

    public static final Function<I18nReferentialDto, String> LABEL6_FUNCTION = I18nReferentialDto::getLabel6;

    public static final Function<I18nReferentialDto, String> LABEL7_FUNCTION = I18nReferentialDto::getLabel7;

    public static final Function<I18nReferentialDto, String> LABEL8_FUNCTION = I18nReferentialDto::getLabel8;

    public static <BeanType extends I18nReferentialDto> Class<BeanType> typeOfI18nReferentialDto() {
        return (Class<BeanType>) I18nReferentialDto.class;
    }

    public static <BeanType extends I18nReferentialDto> void copyI18nReferentialDto(BeanType source, BeanType target) {
        Class<BeanType> sourceType = typeOfI18nReferentialDto();
        Binder<BeanType, BeanType> binder = BinderFactory.newBinder(sourceType);
        binder.copy(source, target);
    }

    public static <BeanType extends I18nReferentialDto> void copyI18nReferentialDto(BeanType source, BeanType target, Binder<BeanType, BeanType> binder) {
        binder.copy(source, target);
    }

    public static <BeanType extends I18nReferentialDto> Predicate<BeanType> newLabel1Predicate(String label1) {
        return o -> Objects.equals(label1, o.getLabel1());

    }

    public static <BeanType extends I18nReferentialDto> List<BeanType> filterByLabel1(Collection<BeanType> $source, String label1) {
        return $source.stream().filter(newLabel1Predicate(label1)).collect(Collectors.toList());
    }

    public static <BeanType extends I18nReferentialDto> Predicate<BeanType> newLabel2Predicate(String label2) {
        return o -> Objects.equals(label2, o.getLabel2());

    }

    public static <BeanType extends I18nReferentialDto> List<BeanType> filterByLabel2(Collection<BeanType> $source, String label2) {
        return $source.stream().filter(newLabel2Predicate(label2)).collect(Collectors.toList());
    }

    public static <BeanType extends I18nReferentialDto> Predicate<BeanType> newLabel3Predicate(String label3) {
        return o -> Objects.equals(label3, o.getLabel3());

    }

    public static <BeanType extends I18nReferentialDto> List<BeanType> filterByLabel3(Collection<BeanType> $source, String label3) {
        return $source.stream().filter(newLabel3Predicate(label3)).collect(Collectors.toList());
    }

    public static <BeanType extends I18nReferentialDto> Predicate<BeanType> newLabel4Predicate(String label4) {
        return o -> Objects.equals(label4, o.getLabel4());

    }

    public static <BeanType extends I18nReferentialDto> List<BeanType> filterByLabel4(Collection<BeanType> $source, String label4) {
        return $source.stream().filter(newLabel4Predicate(label4)).collect(Collectors.toList());
    }

    public static <BeanType extends I18nReferentialDto> Predicate<BeanType> newLabel5Predicate(String label5) {
        return o -> Objects.equals(label5, o.getLabel5());

    }

    public static <BeanType extends I18nReferentialDto> List<BeanType> filterByLabel5(Collection<BeanType> $source, String label5) {
        return $source.stream().filter(newLabel5Predicate(label5)).collect(Collectors.toList());
    }

    public static <BeanType extends I18nReferentialDto> Predicate<BeanType> newLabel6Predicate(String label6) {
        return o -> Objects.equals(label6, o.getLabel6());

    }

    public static <BeanType extends I18nReferentialDto> List<BeanType> filterByLabel6(Collection<BeanType> $source, String label6) {
        return $source.stream().filter(newLabel6Predicate(label6)).collect(Collectors.toList());
    }

    public static <BeanType extends I18nReferentialDto> Predicate<BeanType> newLabel7Predicate(String label7) {
        return o -> Objects.equals(label7, o.getLabel7());

    }

    public static <BeanType extends I18nReferentialDto> List<BeanType> filterByLabel7(Collection<BeanType> $source, String label7) {
        return $source.stream().filter(newLabel7Predicate(label7)).collect(Collectors.toList());
    }

    public static <BeanType extends I18nReferentialDto> Predicate<BeanType> newLabel8Predicate(String label8) {
        return o -> Objects.equals(label8, o.getLabel8());

    }

    public static <BeanType extends I18nReferentialDto> List<BeanType> filterByLabel8(Collection<BeanType> $source, String label8) {
        return $source.stream().filter(newLabel8Predicate(label8)).collect(Collectors.toList());
    }

    public static <BeanType extends I18nReferentialDto> ImmutableMap<String, BeanType> uniqueIndexByLabel1(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, LABEL1_FUNCTION::apply);
    }

    public static <BeanType extends I18nReferentialDto> ImmutableMap<String, BeanType> uniqueIndexByLabel2(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, LABEL2_FUNCTION::apply);
    }

    public static <BeanType extends I18nReferentialDto> ImmutableMap<String, BeanType> uniqueIndexByLabel3(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, LABEL3_FUNCTION::apply);
    }

    public static <BeanType extends I18nReferentialDto> ImmutableMap<String, BeanType> uniqueIndexByLabel4(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, LABEL4_FUNCTION::apply);
    }

    public static <BeanType extends I18nReferentialDto> ImmutableMap<String, BeanType> uniqueIndexByLabel5(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, LABEL5_FUNCTION::apply);
    }

    public static <BeanType extends I18nReferentialDto> ImmutableMap<String, BeanType> uniqueIndexByLabel6(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, LABEL6_FUNCTION::apply);
    }

    public static <BeanType extends I18nReferentialDto> ImmutableMap<String, BeanType> uniqueIndexByLabel7(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, LABEL7_FUNCTION::apply);
    }

    public static <BeanType extends I18nReferentialDto> ImmutableMap<String, BeanType> uniqueIndexByLabel8(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, LABEL8_FUNCTION::apply);
    }


}
