/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.spi.map.ImmutableSetMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ImmutableSetStringMap
extends ImmutableSetMap<String> {
    ImmutableSetStringMap(ImmutableMap<String, Set<String>> data, ImmutableMap<String, Class> types) {
        super(data, types);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Set<String>> data = new TreeMap<String, Set<String>>();
        private final ImmutableMap.Builder<String, Class> types = ImmutableMap.builder();

        public Builder put(Class type, String value) {
            String key = ImmutableSetMap.keyFunction.apply(type);
            this.data.computeIfAbsent(key, k -> new LinkedHashSet()).add(value);
            this.types.put((Object)key, (Object)type);
            return this;
        }

        public Builder put(Class type, Set<String> value) {
            String key = ImmutableSetMap.keyFunction.apply(type);
            this.data.computeIfAbsent(key, e -> new LinkedHashSet()).addAll(value);
            this.types.put((Object)key, (Object)type);
            return this;
        }

        public ImmutableSetStringMap build() {
            return new ImmutableSetStringMap((ImmutableMap<String, Set<String>>)ImmutableMap.copyOf(this.data), (ImmutableMap<String, Class>)this.types.build());
        }
    }
}

