/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.spi.map.ImmutableSetMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ImmutableSetDtoMap<V>
extends ImmutableSetMap<V> {
    ImmutableSetDtoMap(ImmutableMap<String, Set<V>> data, ImmutableMap<String, Class> types) {
        super(data, types);
    }

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    public static class Builder<V> {
        private final Map<String, Set<V>> data = new TreeMap<String, Set<V>>();
        private final ImmutableMap.Builder<String, Class> types = ImmutableMap.builder();

        public Builder put(Class type, V value) {
            String key = ImmutableSetMap.keyFunction.apply(type);
            this.data.computeIfAbsent(key, e -> new LinkedHashSet()).add(value);
            this.types.put((Object)key, (Object)type);
            return this;
        }

        public <VV extends V> Builder put(Class type, Collection<VV> value) {
            String key = ImmutableSetMap.keyFunction.apply(type);
            this.data.computeIfAbsent(key, e -> new LinkedHashSet()).addAll(value);
            this.types.put((Object)key, (Object)type);
            return this;
        }

        public ImmutableSetDtoMap<V> build() {
            return new ImmutableSetDtoMap(ImmutableMap.copyOf(this.data), (ImmutableMap<String, Class>)this.types.build());
        }
    }
}

