/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi;

import com.google.common.collect.ImmutableSet;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.IdHelper;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.form.FormDefinition;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.spi.context.DataDtoContext;
import fr.ird.observe.spi.context.DataFormContext;
import fr.ird.observe.spi.context.ReferentialDtoContext;
import fr.ird.observe.spi.context.ReferentialFormContext;
import fr.ird.observe.spi.initializer.DtoFormsInitializerSupport;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;
import fr.ird.observe.spi.map.ImmutableDtoMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DtoModelHelper {
    private static final Logger log = LogManager.getLogger(DtoModelHelper.class);
    private static final DtoModelHelper INSTANCE = new DtoModelHelper();
    private static DtoFormsInitializerSupport FORM_INITIALIZER;
    private static DtoReferencesInitializerSupport REFERENCES_INITIALIZER;
    private final ImmutableDtoMap<ReferentialDtoContext> referentialDtoContext;
    private final ImmutableDtoMap<ReferentialFormContext> referentialFormContext;
    private final ImmutableDtoMap<DataDtoContext> dataDtoContext;
    private final ImmutableDtoMap<DataFormContext> dataFormContext;
    private final ImmutableSet<Class> referentialClasses;
    private final ImmutableSet<Class> mainDataClasses;

    protected DtoModelHelper() {
        log.info("Dto model helper initialization  (" + this + ").");
        DtoReferencesInitializerSupport referencesInitializer = DtoModelHelper.getReferencesInitializer();
        DtoFormsInitializerSupport formInitializer = DtoModelHelper.getFormInitializer();
        ImmutableDtoMap.Builder<ReferentialDtoContext> referentialDtoContextBuilder = ImmutableDtoMap.builder();
        ImmutableDtoMap.Builder<ReferentialFormContext> referentialFormContextBuilder = ImmutableDtoMap.builder();
        ImmutableDtoMap.Builder<DataDtoContext> dataDtoContextBuilder = ImmutableDtoMap.builder();
        ImmutableDtoMap.Builder<DataFormContext> dataFormContextBuilder = ImmutableDtoMap.builder();
        LinkedHashSet<Class> mainDataClassesBuilder = new LinkedHashSet<Class>();
        LinkedHashSet<Class> referentialClassesBuilder = new LinkedHashSet<Class>();
        Collection<Class<? extends IdDto>> dtoTypesWithReference = referencesInitializer.getReferenceToDtoClassMapping().values();
        int referentialCount = 0;
        for (Class dtoType : referencesInitializer.getReferentialTypes()) {
            DtoModelHelper.registerReferential(dtoType, referencesInitializer, formInitializer, referentialDtoContextBuilder, referentialFormContextBuilder);
            referentialClassesBuilder.add(dtoType);
            ++referentialCount;
        }
        log.info("Load " + referentialCount + " referential definitions.");
        Set<Class> dtoTypesWithForm = formInitializer.getDtoToFormClassMapping().keys();
        int dataCountWithReference = 0;
        int dataCountWithForm = 0;
        LinkedHashSet<Class<? extends DataDto>> dataTypes = new LinkedHashSet<Class<? extends DataDto>>((Collection<Class<? extends DataDto>>)referencesInitializer.getDataTypes());
        dataTypes.addAll(dtoTypesWithForm);
        for (Class dtoType : dataTypes) {
            FormDefinition<? extends IdDto> formDefinition;
            Class formType = formInitializer.getDtoToFormClassMapping().forData(dtoType);
            if (dtoTypesWithForm.contains(formType) && (formDefinition = formInitializer.getFormDefinitions().get(formType)) != null) {
                DtoModelHelper.registerDataForm(dtoType, formType, formDefinition, dataFormContextBuilder);
                ++dataCountWithForm;
            }
            mainDataClassesBuilder.add(dtoType);
            if (referencesInitializer.getDtoToReferenceClassMapping().forData(dtoType) == null) continue;
            if (dtoTypesWithReference.contains(dtoType)) {
                DtoModelHelper.registerDataWithReference(dtoType, referencesInitializer, dataDtoContextBuilder);
                ++dataCountWithReference;
                continue;
            }
            DtoModelHelper.registerData(dtoType, referencesInitializer, dataDtoContextBuilder);
        }
        log.info("Load " + dataCountWithReference + " reference definitions.");
        log.info("Load " + dataCountWithForm + " form definitions.");
        log.info("Load " + referencesInitializer.getReferentialBinders().size() + " dto referential binders.");
        log.info("Load " + referencesInitializer.getDataBinders().size() + " dto data binders.");
        this.referentialDtoContext = referentialDtoContextBuilder.build();
        this.referentialFormContext = referentialFormContextBuilder.build();
        this.referentialClasses = ImmutableSet.copyOf(referentialClassesBuilder);
        this.dataDtoContext = dataDtoContextBuilder.build();
        this.dataFormContext = dataFormContextBuilder.build();
        this.mainDataClasses = ImmutableSet.copyOf(mainDataClassesBuilder);
        log.info("Dto model helper is initialized (" + this + ").");
    }

    public static Set<Class<? extends ReferentialDto>> getReferentialClasses() {
        return DtoModelHelper.INSTANCE.referentialClasses;
    }

    public static Set<Class<? extends DataDto>> getMainDataClasses() {
        return DtoModelHelper.INSTANCE.mainDataClasses;
    }

    public static Set<Class<? extends ReferentialDto>> filterReferentialDto(Collection<Class<? extends IdDto>> types) {
        return types.stream().filter(ReferentialDto.class::isAssignableFrom).collect(Collectors.toSet());
    }

    public static Set<Class<? extends DataDto>> filterDataDto(Collection<Class<? extends IdDto>> types) {
        return types.stream().filter(DataDto.class::isAssignableFrom).collect(Collectors.toSet());
    }

    public static <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> ReferentialDtoContext<D, R> fromReferentialDto(Class<D> dtoType) {
        return DtoModelHelper.INSTANCE.referentialDtoContext.get(dtoType);
    }

    public static <D extends DataDto, R extends DataDtoReference<D, R>> DataDtoContext<D, R> fromDataDto(Class<D> dtoType) {
        return DtoModelHelper.INSTANCE.dataDtoContext.get(dtoType);
    }

    public static <D extends IdDto> Optional<FormDefinition<D>> getOptionalFormDefinition(Class<? extends IdDto> dtoType) {
        if (IdHelper.isReferential(dtoType)) {
            Optional optional = Optional.ofNullable(DtoModelHelper.fromReferentialForm(dtoType));
            return optional.map(ReferentialFormContext::toFormDefinition);
        }
        Optional optional = Optional.ofNullable(DtoModelHelper.fromDataForm(dtoType));
        return optional.map(DataFormContext::toFormDefinition);
    }

    static <D extends ReferentialDto, F extends ReferentialDto> ReferentialFormContext<D, F> fromReferentialForm(Class<D> dtoType) {
        return DtoModelHelper.INSTANCE.referentialFormContext.get(dtoType);
    }

    static <D extends DataDto, F extends DataDto> DataFormContext<D, F> fromDataForm(Class<D> dtoType) {
        return DtoModelHelper.INSTANCE.dataFormContext.get(dtoType);
    }

    public static DtoReferencesInitializerSupport getReferencesInitializer() {
        if (REFERENCES_INITIALIZER == null) {
            REFERENCES_INITIALIZER = DtoModelHelper.getService(DtoReferencesInitializerSupport.class);
        }
        return REFERENCES_INITIALIZER;
    }

    static DtoFormsInitializerSupport getFormInitializer() {
        if (FORM_INITIALIZER == null) {
            FORM_INITIALIZER = DtoModelHelper.getService(DtoFormsInitializerSupport.class);
        }
        return FORM_INITIALIZER;
    }

    private static <D extends ReferentialDto> void registerReferential(Class<D> dtoType, DtoReferencesInitializerSupport referencesInitializer, DtoFormsInitializerSupport formInitializer, ImmutableDtoMap.Builder<ReferentialDtoContext> referentialDtoContextBuilder, ImmutableDtoMap.Builder<ReferentialFormContext> referentialFormContextBuilder) {
        referentialDtoContextBuilder.put(dtoType, new ReferentialDtoContext(dtoType, referencesInitializer));
        referentialFormContextBuilder.put(dtoType, new ReferentialFormContext<D, IdDto>(dtoType, dtoType, formInitializer.getFormDefinitions().get(dtoType)));
    }

    private static <D extends DataDto> void registerData(Class<D> dtoType, DtoReferencesInitializerSupport referencesInitializer, ImmutableDtoMap.Builder<DataDtoContext> dataDtoContextBuilder) {
        dataDtoContextBuilder.put(dtoType, new DataDtoContext(dtoType, referencesInitializer));
    }

    private static <D extends DataDto, F extends DataDto> void registerDataForm(Class<D> dtoType, Class<F> formType, FormDefinition<F> referencesInitializer, ImmutableDtoMap.Builder<DataFormContext> dataFormContextBuilder) {
        dataFormContextBuilder.put(dtoType, new DataFormContext<D, F>(dtoType, formType, referencesInitializer));
    }

    private static <D extends DataDto> void registerDataWithReference(Class<D> dtoType, DtoReferencesInitializerSupport referencesInitializer, ImmutableDtoMap.Builder<DataDtoContext> dataDtoContextBuilder) {
        dataDtoContextBuilder.put(dtoType, new DataDtoContext(dtoType, referencesInitializer));
    }

    public static <S> S getService(Class<S> serviceType) {
        Iterator<S> iterator = ServiceLoader.load(serviceType).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new IllegalStateException("No instance found for " + serviceType.getName());
    }
}

