/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.referential;

import fr.ird.observe.dto.referential.FormulaHelper;
import fr.ird.observe.dto.referential.WithStartEndDate;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface WithFormula
extends WithStartEndDate {
    public static final String PROPERTY_OCEAN = "ocean";
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SEX = "sex";
    public static final String PROPERTY_START_DATE = "startDate";
    public static final String PROPERTY_END_DATE = "endDate";
    public static final String PROPERTY_COEFFICIENTS = "coefficients";
    public static final String PROPERTY_SOURCE = "source";
    public static final Comparator<WithFormula> FORMULA_SUPPORT_START_DATE_COMPARATOR = Comparator.comparing(WithStartEndDate::getStartDate, WithStartEndDate.START_DATE_COMPARATOR);
    public static final Comparator<WithFormula> FORMULA_SUPPORT_END_DATE_COMPARATOR = Comparator.comparing(WithStartEndDate::getEndDate, WithStartEndDate.END_DATE_COMPARATOR);
    public static final Comparator<WithFormula> FORMULA_SUPPORT_COMPARATOR = FORMULA_SUPPORT_START_DATE_COMPARATOR.thenComparing(FORMULA_SUPPORT_END_DATE_COMPARATOR);

    public static <D extends WithFormula> void sort(List<D> list) {
        list.sort(FORMULA_SUPPORT_COMPARATOR);
    }

    public String getCoefficients();

    public void setCoefficients(String var1);

    public Map<String, Double> getCoefficientValues();

    public String getFormulaOneVariableName();

    public String getFormulaTwoVariableName();

    public void setStartDate(Date var1);

    public void setEndDate(Date var1);

    public String getSource();

    public void setSource(String var1);

    default public Set<String> getCoefficientNames() {
        return this.getCoefficientValues().keySet();
    }

    public String getFormulaOne();

    public String getFormulaTwo();

    default public void revalidateFormulaOne() {
        boolean result = FormulaHelper.validateRelation(this, this.getFormulaOne(), this.getFormulaOneVariableName());
        this.setFormulaOneValid(result);
    }

    public boolean isFormulaOneValid();

    public void setFormulaOneValid(boolean var1);

    public boolean isFormulaTwoValid();

    public void setFormulaTwoValid(boolean var1);

    default public void revalidateFormulaTwo() {
        boolean result = FormulaHelper.validateRelation(this, this.getFormulaTwo(), this.getFormulaTwoVariableName());
        this.setFormulaTwoValid(result);
    }

    default public Double getCoefficientValue(String coefficientName) {
        return this.getCoefficientValues().get(coefficientName);
    }
}

