/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.reference;

import com.google.common.base.MoreObjects;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceAware;
import fr.ird.observe.dto.referential.ReferentialDto;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ReferentialDtoReference<D extends ReferentialDto, R extends ReferentialDtoReference<D, R>>
extends DtoReference<D, R>
implements ReferentialDtoReferenceAware {
    public static final String PROPERTY_ENABLED = "enabled";
    private static final Log log = LogFactory.getLog(ReferentialDtoReference.class);
    private final boolean needComment;
    private final boolean enabled;

    protected ReferentialDtoReference(ReferentialDtoReferenceAware dto) {
        super(dto);
        this.enabled = dto.isEnabled();
        this.needComment = dto.isNeedComment();
    }

    @Override
    public boolean isNeedComment() {
        return this.needComment;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getDtoType().getSimpleName()).add("id", (Object)this.getId());
        if (log.isDebugEnabled()) {
            toStringHelper.add(PROPERTY_ENABLED, this.enabled).add("needComment", this.needComment).add("createDate", (Object)this.getCreateDate()).add("lastUpdateDate", (Object)this.getLastUpdateDate()).add("version", this.getVersion());
        }
        return toStringHelper.toString();
    }
}

