/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import fr.ird.observe.dto.IdHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;

public class MutableDtoMap<V> {
    private static final transient Function<Class, String> keyFunction = IdHelper::getDtoSimplifiedName;
    private final Map<String, V> data;

    public static <V> MutableDtoMap<V> create() {
        return new MutableDtoMap<V>();
    }

    protected MutableDtoMap(MutableDtoMap<V> dtoMap) {
        this.data = dtoMap.data;
    }

    private MutableDtoMap() {
        this.data = new TreeMap<String, V>();
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public V get(Class key) {
        return this.data.get(this.key0(key));
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Collection<V> values() {
        return this.data.values();
    }

    public void put(Class type, V value) {
        this.data.put(this.key0(type), value);
    }

    public void clear() {
        this.data.clear();
    }

    protected String key0(Class type) {
        return keyFunction.apply(type);
    }
}

