/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.context;

import fr.ird.observe.binder.data.DataDtoReferenceBinder;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DataDtoReferenceDefinition;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;

public class DataReferenceContext<D extends DataDto, R extends DataDtoReference<D, R>> {
    private final Class<D> dtoType;
    private final DataDtoReferenceBinder<D, R> referenceBinder;
    private final DataDtoReferenceDefinition<D, R> referenceDefinition;
    private final Class<R> referenceType;

    DataReferenceContext(Class<R> referenceType, DtoReferencesInitializerSupport modelHelper) {
        this.referenceType = referenceType;
        this.dtoType = modelHelper.getReferenceToDtoClassMapping().forData(referenceType);
        this.referenceBinder = modelHelper.getDataBinders().get(referenceType);
        this.referenceDefinition = modelHelper.getDataReferenceSetDefinition().get(referenceType);
    }

    public Class<R> toReferenceType() {
        return this.referenceType;
    }

    public Class<D> toDtoType() {
        return this.dtoType;
    }

    public DataDtoReferenceBinder<D, R> toReferenceBinder() {
        return this.referenceBinder;
    }

    public DtoReferenceDefinition<D, R> toReferenceDefinition() {
        return this.referenceDefinition;
    }
}

