/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.reference;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.reference.DtoReference;
import java.io.Serializable;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DtoReferenceDefinition<D extends IdDto, R extends DtoReference<D, R>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DtoReferenceDefinition.class);
    private final Class<D> dtoType;
    private final Class<R> referenceType;
    private final ImmutableMap<String, Class<?>> properties;
    private final ImmutableMap<String, Function<R, ?>> functions;

    protected DtoReferenceDefinition(Class<D> dtoType, Class<R> referenceType, ImmutableMap<String, Class<?>> properties, ImmutableMap<String, Function<R, ?>> functions) {
        this.dtoType = dtoType;
        this.referenceType = referenceType;
        this.properties = properties;
        this.functions = functions;
    }

    public Class<R> getType() {
        return this.referenceType;
    }

    public Class<D> getDtoType() {
        return this.dtoType;
    }

    ImmutableSet<String> getPropertyNames() {
        return this.properties.keySet();
    }

    <O> Function<R, O> getPropertyFunction(String propertyName) {
        return (Function)this.functions.get((Object)propertyName);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("referenceType", (Object)this.referenceType.getSimpleName());
        if (log.isDebugEnabled()) {
            toStringHelper.add("properties", this.properties);
        }
        return toStringHelper.toString();
    }

    public static abstract class Builder<D extends IdDto, R extends DtoReference<D, R>, X extends DtoReferenceDefinition<D, R>> {
        final Class<D> dtoType;
        final Class<R> referenceType;
        final ImmutableMap.Builder<String, Class<?>> propertiesBuilder;
        final ImmutableMap.Builder<String, Function<R, ?>> functionsBuilder;

        public Builder(Class<D> dtoType, Class<R> referenceType) {
            this.dtoType = dtoType;
            this.referenceType = referenceType;
            this.propertiesBuilder = ImmutableMap.builder();
            this.functionsBuilder = ImmutableMap.builder();
        }

        public <O> Builder<D, R, X> addProperty(Class<O> type, String name, Function<R, O> function) {
            this.propertiesBuilder.put((Object)name, type);
            this.functionsBuilder.put((Object)name, function);
            return this;
        }

        public Class<R> getType() {
            return this.referenceType;
        }

        public abstract X build();
    }
}

