/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto;

import io.ultreia.java4all.config.ApplicationConfig;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;

public class ObserveUtil {
    public static Properties loadProperties(Properties sourceProperties, ApplicationConfig config) {
        Properties targetProperties = new Properties();
        for (Map.Entry<Object, Object> entry : sourceProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String newValue = config.replaceRecursiveOptions(value);
            targetProperties.setProperty(key, newValue);
        }
        return targetProperties;
    }

    public static <C extends Class<?>> List<C> sortTypes(Collection<C> types, Function<Class, String> function, Locale locale) {
        ArrayList<C> list = new ArrayList<C>(types);
        new ClassComparator<C>(function, locale).sort(list);
        return list;
    }

    private static class ClassComparator<C extends Class<?>>
    implements Comparator<C> {
        private final Map<Class, String> cache = new HashMap<Class, String>();
        private final Function<Class, String> function;
        private final Collator collator;

        private ClassComparator(Function<Class, String> function, Locale locale) {
            this.function = function;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(0);
        }

        @Override
        public int compare(Class o1, Class o2) {
            String s1 = this.getValue(o1);
            String s2 = this.getValue(o2);
            return this.collator.compare(s1, s2);
        }

        String getValue(Class klass) {
            return this.cache.computeIfAbsent(klass, k -> this.function.apply(klass));
        }

        public void sort(List<C> list) {
            list.sort(this);
            this.cache.clear();
        }
    }
}

