/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdHelper;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ImmutableSetDtoMap<V> {
    private static final transient Function<Class, String> keyFunction = IdHelper::getDtoSimplifiedName;
    private final ImmutableMap<String, Set<V>> data;
    private final ImmutableMap<String, Class> types;

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    ImmutableSetDtoMap(ImmutableMap<String, Set<V>> data, ImmutableMap<String, Class> types) {
        this.data = data;
        this.types = types;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Set<V> get(Class key) {
        return (Set)this.data.get((Object)this.key0(key));
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Collection<Set<V>> values() {
        return this.data.values();
    }

    public boolean containsEntry(Class type, V value) {
        String key = this.key0(type);
        return this.data.containsKey((Object)key) && ((Set)this.data.get((Object)key)).contains(value);
    }

    public Set<Class<? extends ReferentialDtoReference>> referentialReferenceTypes() {
        return this.types.values().stream().filter(IdHelper::isReferential).collect(Collectors.toSet());
    }

    private String key0(Class type) {
        return keyFunction.apply(type);
    }

    public static class Builder<V> {
        private final Map<String, Set<V>> data = new TreeMap<String, Set<V>>();
        private final ImmutableMap.Builder<String, Class> types = ImmutableMap.builder();

        public Builder put(Class type, V value) {
            String key = (String)keyFunction.apply(type);
            ((Set)this.data.getOrDefault(key, new LinkedHashSet())).add(value);
            this.types.put((Object)key, (Object)type);
            return this;
        }

        public <VV extends V> Builder put(Class type, Set<VV> value) {
            String key = (String)keyFunction.apply(type);
            this.data.put(key, value);
            this.types.put((Object)key, (Object)type);
            return this;
        }

        public ImmutableSetDtoMap<V> build() {
            return new ImmutableSetDtoMap(ImmutableMap.copyOf(this.data), (ImmutableMap<String, Class>)this.types.build());
        }
    }
}

