/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.referential;

import fr.ird.observe.dto.referential.I18nReferentialDto;
import fr.ird.observe.dto.referential.I18nReferentialHelper;
import java.util.Locale;

public enum ReferentialLocale {
    UK(Locale.UK),
    FR(Locale.FRANCE),
    ES(new Locale("es", "ES"));

    private final Locale locale;

    private ReferentialLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLibelle() {
        return "label" + (this.ordinal() + 1);
    }

    public static ReferentialLocale valueOf(Locale locale) {
        for (ReferentialLocale anEnum : ReferentialLocale.values()) {
            if (!locale.equals(anEnum.getLocale())) continue;
            return anEnum;
        }
        throw new IllegalArgumentException("could not find referentiel locale from locale " + locale);
    }

    public String getColumnName() {
        return "label" + (this.ordinal() + 1);
    }

    public String toString() {
        return "<ReferentialLocale: " + this.locale + ", index: " + this.name() + ">";
    }

    public <E extends I18nReferentialDto> void setLabel(String label, E i18nDto) {
        switch (this.ordinal() + 1) {
            case 1: {
                i18nDto.setLabel1(label);
                break;
            }
            case 2: {
                i18nDto.setLabel2(label);
                break;
            }
            case 3: {
                i18nDto.setLabel3(label);
                break;
            }
            case 4: {
                i18nDto.setLabel4(label);
                break;
            }
            case 5: {
                i18nDto.setLabel5(label);
                break;
            }
            case 6: {
                i18nDto.setLabel6(label);
                break;
            }
            case 7: {
                i18nDto.setLabel7(label);
                break;
            }
            case 8: {
                i18nDto.setLabel8(label);
            }
        }
    }

    public <E extends I18nReferentialDto> String getLabel(E i18nEntity) {
        return I18nReferentialHelper.decorate(this.ordinal(), i18nEntity);
    }
}

