/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.reference;

import com.google.common.collect.Maps;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.DtoReferenceAware;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class DtoReferenceSupport<D extends IdDto, R extends DtoReferenceSupport<D, R>>
extends IdDto
implements DtoReference<D, R> {
    protected DtoReferenceSupport(DtoReferenceAware dto) {
        Objects.requireNonNull(dto);
        this.id = dto.getTopiaId();
        this.version = dto.getTopiaVersion();
        this.createDate = dto.getTopiaCreateDate();
    }

    public static <BeanType extends DtoReferenceSupport> Predicate<BeanType> newIdPredicate(String id) {
        return input -> Objects.equals(id, input.getId());
    }

    public static <BeanType extends DtoReferenceSupport> Map<String, BeanType> splitById(Collection<BeanType> dtos) {
        return Maps.uniqueIndex(dtos, IdDto::getId);
    }

    public static <BeanType extends DtoReferenceSupport> Collection<BeanType> filterById(Collection<BeanType> source, String id) {
        return source.stream().filter(DtoReferenceSupport.newIdPredicate(id)).collect(Collectors.toList());
    }

    public static <BeanType extends DtoReferenceSupport> BeanType find(Collection<BeanType> source, String id) {
        return (BeanType)((DtoReferenceSupport)source.stream().filter(DtoReferenceSupport.newIdPredicate(id)).findFirst().orElse(null));
    }

    @Override
    public final Date getCreateDate() {
        return this.createDate;
    }

    @Override
    public final long getVersion() {
        return this.version;
    }
}

