/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.reference;

import com.google.common.collect.ImmutableSet;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.ObserveDto;
import fr.ird.observe.dto.reference.DtoReferenceAware;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import java.util.Date;
import java.util.function.Function;

public interface DtoReference<D extends IdDto, R extends DtoReference<D, R>>
extends ObserveDto,
DtoReferenceAware {
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_CREATE_DATE = "createDate";
    public static final String PROPERTY_VERSION = "version";

    public DtoReferenceDefinition<D, R> getDefinition();

    public String getId();

    public Date getCreateDate();

    public Date getLastUpdateDate();

    public long getVersion();

    default public <O> O getPropertyValue(String propertyName) {
        Function propertyFunction = this.getDefinition().getPropertyFunction(propertyName);
        return propertyFunction.apply(this);
    }

    default public Class<D> getDtoType() {
        return this.getDefinition().getDtoType();
    }

    default public Class<R> getReferenceType() {
        return this.getDefinition().getType();
    }

    default public ImmutableSet<String> getPropertyNames() {
        return this.getDefinition().getPropertyNames();
    }
}

