/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.form;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.IdHelper;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceSupport;
import fr.ird.observe.dto.referential.ReferentialDto;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FormDefinition<D extends IdDto> {
    private final String key;
    private final Class<D> type;
    private final ImmutableMap<String, DtoReferenceDefinition<?, ?>> properties;

    public static <D extends IdDto> Builder<D> builder(Class<D> type, ImmutableMap<String, DtoReferenceDefinition> referentialDtoReferenceDefinitions) {
        return new Builder<D>(type, referentialDtoReferenceDefinitions);
    }

    public ImmutableMap<String, DtoReferenceDefinition<?, ?>> getProperties() {
        return this.properties;
    }

    FormDefinition(Class<D> type, ImmutableMap<String, DtoReferenceDefinition<?, ?>> properties) {
        this.type = type;
        this.properties = properties;
        this.key = IdHelper.cleanId(type.getName());
    }

    public Class<D> getType() {
        return this.type;
    }

    public String name() {
        return this.type.getName();
    }

    public Set<Class<?>> getPropertiesTypes() {
        return this.properties.values().stream().map(DtoReferenceDefinition::getDtoType).collect(Collectors.toSet());
    }

    public Set<Class<?>> getPropertiesReferenceTypes() {
        return this.properties.values().stream().map(DtoReferenceDefinition::getType).collect(Collectors.toSet());
    }

    public static class Builder<D extends IdDto> {
        private final Class<D> type;
        private final ImmutableMap<String, DtoReferenceDefinition> referentialDtoReferenceDefinitions;
        private final ImmutableMap.Builder<String, DtoReferenceDefinition<?, ?>> propertiesBuilder;

        public Builder(Class<D> type, ImmutableMap<String, DtoReferenceDefinition> referentialDtoReferenceDefinitions) {
            this.type = type;
            this.referentialDtoReferenceDefinitions = referentialDtoReferenceDefinitions;
            this.propertiesBuilder = ImmutableMap.builder();
        }

        public FormDefinition<D> build(ImmutableMap.Builder<String, FormDefinition<? extends IdDto>> formDefinitionBuilder) {
            FormDefinition<D> definition = new FormDefinition<D>(this.type, this.propertiesBuilder.build());
            formDefinitionBuilder.put((Object)this.type.getName().replace("Dto", ""), definition);
            return definition;
        }

        public <DD extends ReferentialDto, RR extends ReferentialDtoReferenceSupport<DD, RR>> Builder<D> addProperty(String name, Class<RR> referenceType) {
            DtoReferenceDefinition<DD, RR> definition = this.referenceSetDefinition(referenceType);
            this.propertiesBuilder.put((Object)name, definition);
            return this;
        }

        private <DD extends ReferentialDto, R extends ReferentialDtoReferenceSupport<DD, R>> DtoReferenceDefinition<DD, R> referenceSetDefinition(Class<R> referenceType) {
            DtoReferenceDefinition referenceDefinition = (DtoReferenceDefinition)this.referentialDtoReferenceDefinitions.get((Object)IdHelper.cleanId(referenceType.getName()));
            Objects.requireNonNull(referenceDefinition, "Could not find referenceSet for type: " + referenceType);
            return referenceDefinition;
        }
    }
}

