/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto;

import fr.ird.observe.common.TripMapPoint;
import fr.ird.observe.dto.IdDto;
import java.util.Collection;
import java.util.LinkedHashSet;

public class TripMapDto
extends IdDto {
    public static final String PROPERTY_POINTS = "points";
    private static final long serialVersionUID = 3487020005850232420L;
    protected LinkedHashSet<TripMapPoint> points;

    public TripMapPoint getPoints(int index) {
        TripMapPoint o = this.getChild(this.points, index);
        return o;
    }

    public boolean isPointsEmpty() {
        return this.points == null || this.points.isEmpty();
    }

    public int sizePoints() {
        return this.points == null ? 0 : this.points.size();
    }

    public void addPoints(TripMapPoint points) {
        this.getPoints().add(points);
        this.firePropertyChange(PROPERTY_POINTS, null, points);
    }

    public void addAllPoints(Collection<TripMapPoint> points) {
        this.getPoints().addAll(points);
        this.firePropertyChange(PROPERTY_POINTS, null, points);
    }

    public boolean removePoints(TripMapPoint points) {
        boolean removed = this.getPoints().remove(points);
        if (removed) {
            this.firePropertyChange(PROPERTY_POINTS, points, null);
        }
        return removed;
    }

    public boolean removeAllPoints(Collection<TripMapPoint> points) {
        boolean removed = this.getPoints().removeAll(points);
        if (removed) {
            this.firePropertyChange(PROPERTY_POINTS, points, null);
        }
        return removed;
    }

    public boolean containsPoints(TripMapPoint points) {
        boolean contains = this.getPoints().contains(points);
        return contains;
    }

    public boolean containsAllPoints(Collection<TripMapPoint> points) {
        boolean contains = this.getPoints().containsAll(points);
        return contains;
    }

    public LinkedHashSet<TripMapPoint> getPoints() {
        if (this.points == null) {
            this.points = new LinkedHashSet();
        }
        return this.points;
    }

    public void setPoints(LinkedHashSet<TripMapPoint> points) {
        LinkedHashSet<TripMapPoint> oldValue = this.getPoints();
        this.points = points;
        this.firePropertyChange(PROPERTY_POINTS, oldValue, points);
    }
}

