/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto;

import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.reference.DtoReferenceSupport;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public class IdHelper {
    public static String cleanId(Class id) {
        return IdHelper.cleanId(id.getSimpleName());
    }

    public static String cleanId(String id) {
        if (id.endsWith("Dto")) {
            return id.substring(0, id.length() - 3);
        }
        if (id.endsWith("Reference")) {
            return id.substring(0, id.length() - 9);
        }
        if (id.endsWith("Impl")) {
            return id.substring(0, id.length() - 4);
        }
        int index = id.indexOf("_");
        if (index > -1) {
            id = id.substring(0, index);
        }
        return id;
    }

    public static <BeanType extends IdDto> BeanType findById(Collection<BeanType> source, String id) {
        return (BeanType)((IdDto)source.stream().filter(IdHelper.newIdPredicate(id)::test).findFirst().orElse(null));
    }

    public static <BeanType extends IdDto> boolean exists(Collection<BeanType> source, String id) {
        return source.stream().anyMatch(IdHelper.newIdPredicate(id)::test);
    }

    public static boolean isProgramId(String id) {
        return id.contains("Program");
    }

    public static boolean isTrip(IdDto dto) {
        return IdHelper.isTripSeineId(dto.getId()) || IdHelper.isTripLonglineId(dto.getId());
    }

    public static boolean isTrip(DtoReferenceSupport dto) {
        return IdHelper.isTripSeineId(dto.getId()) || IdHelper.isTripLonglineId(dto.getId());
    }

    public static boolean isTripLonglineId(String id) {
        return id.contains("TripLongline");
    }

    public static boolean isTripSeineId(String id) {
        return id.contains("TripSeine");
    }

    public static boolean isRouteId(String id) {
        return id.contains("Route");
    }

    public static boolean isActivitySeine(IdDto dto) {
        return IdHelper.isActivitySeineId(dto.getId());
    }

    public static boolean isActivitySeineId(String id) {
        return id.contains("ActivitySeine");
    }

    public static boolean isActivityLongline(IdDto dto) {
        return IdHelper.isActivityLonglineId(dto.getId());
    }

    public static boolean isActivityLonglineId(String id) {
        return id.contains("ActivityLongline");
    }

    public static boolean isSetSeine(IdDto dto) {
        return IdHelper.isSetSeineId(dto.getId());
    }

    public static boolean isSetSeineId(String id) {
        return id.contains("SetSeine");
    }

    public static boolean isSetLongline(IdDto dto) {
        return IdHelper.isSetLonglineId(dto.getId());
    }

    public static boolean isSetLonglineId(String id) {
        return id.contains("SetLongline");
    }

    public static boolean isFloatingObject(IdDto dto) {
        return IdHelper.isFloatingObjectId(dto.getId());
    }

    public static boolean isFloatingObjectId(String id) {
        return id.contains("FloatingObject");
    }

    public static boolean isSeineId(String id) {
        return id.contains("Seine");
    }

    public static boolean isLonglineId(String id) {
        return id.contains("Longline");
    }

    public static <BeanType extends IdDto> Predicate<BeanType> newIdPredicate(String id) {
        return o -> Objects.equals(id, o.getId());
    }
}

