/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.binder;

import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.IdHelper;
import fr.ird.observe.dto.constants.ReferentialLocale;
import fr.ird.observe.dto.reference.DtoReference;

public abstract class DtoReferenceBinderSupport<D extends IdDto, R extends DtoReference<D, R>> {
    private final Class<D> dtoType;
    private final Class<R> referenceType;
    private final String key;

    public DtoReferenceBinderSupport(Class<D> dtoType, Class<R> referenceType) {
        this.dtoType = dtoType;
        this.referenceType = referenceType;
        this.key = IdHelper.cleanId(dtoType);
    }

    public static String generateBinderName(int defaultPackageNameLength, String binderPackageName, String fqn, String dtoName, boolean referential) {
        String relativeName = fqn.substring(defaultPackageNameLength);
        if (referential) {
            binderPackageName = binderPackageName + ".referential.";
            if (relativeName.contains(".longline")) {
                return binderPackageName + "longline." + dtoName + "Binder";
            }
            if (relativeName.contains(".seine")) {
                return binderPackageName + "seine." + dtoName + "Binder";
            }
            return binderPackageName + "common." + dtoName + "Binder";
        }
        binderPackageName = binderPackageName + ".data.";
        if (relativeName.startsWith("longline")) {
            return binderPackageName + "longline." + dtoName + "Binder";
        }
        return binderPackageName + "seine." + dtoName + "Binder";
    }

    public String getKey() {
        return this.key;
    }

    public Class<D> getDtoType() {
        return this.dtoType;
    }

    public Class<R> getReferenceType() {
        return this.referenceType;
    }

    public abstract R toReference(ReferentialLocale var1, D var2);
}

