package fr.ird.observe.dto.reference;

/*
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2017 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import fr.ird.observe.dto.ObserveDto;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class DtoReferenceCollectionSupport<R extends DtoReferenceSupport> implements ObserveDto, Serializable {

    public static final String PROPERTY_TYPE = "type";

    public static final String PROPERTY_REFERENCES = "references";

    private static final long serialVersionUID = 1L;

    final Class<R> type;

    private final List<R> references;

    DtoReferenceCollectionSupport(Class<R> type, List<R> references) {
        this.type = type;
        this.references = references;
    }

    public static <R extends ReferentialDtoReferenceSupport> List<R> filterEnabled(Collection<R> references) {

        return references.stream().filter(ReferentialDtoReferenceSupport::isEnabled).collect(Collectors.toList());

    }

    public static <R extends ReferentialDtoReferenceSupport> List<R> filterContains(Collection<R> references, Set<String> containsIds) {

        return references.stream().filter(r -> containsIds.contains(r.getId())).collect(Collectors.toList());

    }

    public static <R extends ReferentialDtoReferenceSupport> List<R> filterNotContains(Collection<R> references, Set<String> containsIds) {

        return references.stream().filter(r -> !containsIds.contains(r.getId())).collect(Collectors.toList());

    }

    public Class<R> getType() {
        return type;
    }

    public R getReferenceById(String id) {
        return tryGetReferenceById(id).orElse(null);
    }

    public Optional<R> tryGetReferenceById(String id) {
        return references.stream().filter(DtoReferenceSupport.newIdPredicate(id)).findFirst();
    }

    public R getReferenceByPosition(int index) {
        return Iterables.get(references, index);
    }

    public int sizeReference() {
        return references.size();
    }

    public Set<R> toSet() {
        return ImmutableSet.copyOf(references);
    }

    public List<R> toList() {
        return ImmutableList.copyOf(references);
    }

}
