package fr.ird.observe.dto.reference;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2017 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.ObserveDto;
import java.util.Date;
import java.util.function.Function;

/**
 * Created by tchemit on 28/08/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public interface DtoReference<D extends IdDto, R extends DtoReference<D, R>> extends ObserveDto, DtoReferenceAware {

    String PROPERTY_TYPE = "type";

    String PROPERTY_CREATE_DATE = "createDate";

    String PROPERTY_VERSION = "version";

    DtoReferenceDefinition<D, R> getDefinition();

    String getId();

    Date getCreateDate();

    Date getLastUpdateDate();

    long getVersion();

    default <O> O getPropertyValue(String propertyName) {
        Function<R, O> propertyFunction = getDefinition().getPropertyFunction(propertyName);
        return propertyFunction.apply((R) this);
    }

    default Class<D> getDtoType() {
        return getDefinition().getDtoType();
    }

    default Class<R> getReferenceType() {
        return getDefinition().getType();
    }

    default ImmutableSet<String> getPropertyNames() {
        return getDefinition().getPropertyNames();
    }

}
