package fr.ird.observe.dto.form;

/*
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2017 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.MoreObjects;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.ObserveDto;
import java.io.Serializable;

public class Form<R extends IdDto> implements ObserveDto, Serializable {

    public static final String PROPERTY_TYPE = "type";

    public static final String PROPERTY_OBJECT = "object";

    public static final String PROPERTY_REFERENTIAL_REFERENCE_SETS_REQUEST_NAME = "referentialReferenceSetsRequestName";

    private static final long serialVersionUID = 1L;

    protected final Class<R> type;

    protected final R object;

    /**
     * Le nom de la requète à utiliser pour récupérer les ensembles de référentiels utilisés par ce formulaire.
     */
    private final String referentialReferenceSetsRequestName;

    public static <R extends IdDto> Form<R> newFormDto(Class<R> type, R object, String referentialReferenceSetsRequestName) {
        return new Form<>(type, object, referentialReferenceSetsRequestName);
    }

    protected Form(Class<R> type, R object, String referentialReferenceSetsRequestName) {
        this.type = type;
        this.object = object;
        this.referentialReferenceSetsRequestName = referentialReferenceSetsRequestName;
    }

    public R getObject() {
        return object;
    }

    public Class<R> getType() {
        return type;
    }

    public String getReferentialReferenceSetsRequestName() {
        return referentialReferenceSetsRequestName;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add(PROPERTY_TYPE, type.getName())
                .add(PROPERTY_REFERENTIAL_REFERENCE_SETS_REQUEST_NAME, referentialReferenceSetsRequestName)
                .toString();
    }

}
