package fr.ird.observe.dto.form;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2017 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.DtoReferenceDefinitionsSupport;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceSupport;
import fr.ird.observe.dto.referential.ReferentialDto;
import io.ultreia.java4all.http.ImmutableClassMapping;

/**
 * Created by tchemit on 28/08/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class DtoFormsInitializerSupport {

    private final ImmutableMap<String, DtoReferenceDefinition> referentialDtoReferenceDefinitions;
    private final ImmutableClassMapping<IdDto, DtoReference> dtoToReferenceClassMapping;

    private final ImmutableClassMapping.Builder<IdDto, IdDto> dtoToFormClassMappingBuilder = ImmutableClassMapping.builder();
    protected final ImmutableMap.Builder<String, FormDefinition<? extends IdDto>> formDefinitionsBuilder = ImmutableMap.builder();
    private ImmutableMap<String, FormDefinition<? extends IdDto>> formDefinitions;
    private ImmutableClassMapping<IdDto, IdDto> dtoToFormClassMapping;

    public DtoFormsInitializerSupport(DtoReferenceDefinitionsSupport referenceDefinitions) {
        this.referentialDtoReferenceDefinitions = referenceDefinitions.getReferential();
        this.dtoToReferenceClassMapping = referenceDefinitions.getDtoToReferenceClassMapping();
    }

    protected <D extends IdDto> FormDefinition.Builder<D> formBuilder(Class<D> type) {
        return new FormDefinition.Builder<>(type, referentialDtoReferenceDefinitions);
    }

    protected <D extends ReferentialDto, R extends ReferentialDtoReferenceSupport<D, R>> FormDefinition.Builder<D> referentialFormBuilder(Class<D> dtoType) {
        Class<R> referenceType = dtoToReferenceClassMapping.get(dtoType);
        FormDefinition.Builder<D> dBuilder = new FormDefinition.Builder<>(dtoType, referentialDtoReferenceDefinitions);
        return dBuilder.addProperty("referentialListHeader", referenceType);
    }

    protected <D extends IdDto, F extends IdDto> void addClassMapping(Class<D> dtoType, Class<F> formType) {
        dtoToFormClassMappingBuilder.put(dtoType, formType);
    }

    public void end() {
        dtoToFormClassMapping = dtoToFormClassMappingBuilder.build();
        formDefinitions = formDefinitionsBuilder.build();
    }

    public ImmutableMap<String, FormDefinition<? extends IdDto>> getFormDefinitions() {
        return formDefinitions;
    }

    public ImmutableClassMapping<IdDto, IdDto> getDtoToFormClassMapping() {
        return dtoToFormClassMapping;
    }
}
