package fr.ird.observe.dto;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2017 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.common.TripMapPoint;
import java.util.Collection;
import java.util.LinkedHashSet;

public class TripMapDto extends IdDto {

    public static final String PROPERTY_POINTS = "points";

    private static final long serialVersionUID = 3487020005850232420L;

    protected LinkedHashSet<TripMapPoint> points;

    public TripMapPoint getPoints(int index) {
        TripMapPoint o = getChild(points, index);
        return o;
    }

    public boolean isPointsEmpty() {
        return points == null || points.isEmpty();
    }

    public int sizePoints() {
        return points == null ? 0 : points.size();
    }

    public void addPoints(TripMapPoint points) {
        getPoints().add(points);
        firePropertyChange(PROPERTY_POINTS, null, points);
    }

    public void addAllPoints(Collection<TripMapPoint> points) {
        getPoints().addAll(points);
        firePropertyChange(PROPERTY_POINTS, null, points);
    }

    public boolean removePoints(TripMapPoint points) {
        boolean removed = getPoints().remove(points);
        if (removed) {
            firePropertyChange(PROPERTY_POINTS, points, null);
        }
        return removed;
    }

    public boolean removeAllPoints(Collection<TripMapPoint> points) {
        boolean removed = getPoints().removeAll(points);
        if (removed) {
            firePropertyChange(PROPERTY_POINTS, points, null);
        }
        return removed;
    }

    public boolean containsPoints(TripMapPoint points) {
        boolean contains = getPoints().contains(points);
        return contains;
    }

    public boolean containsAllPoints(Collection<TripMapPoint> points) {
        boolean contains = getPoints().containsAll(points);
        return contains;
    }

    public LinkedHashSet<TripMapPoint> getPoints() {
        if (points == null) {
            points = new LinkedHashSet<TripMapPoint>();
        }
        return points;
    }

    public void setPoints(LinkedHashSet<TripMapPoint> points) {
        LinkedHashSet<TripMapPoint> oldValue = getPoints();
        this.points = points;
        firePropertyChange(PROPERTY_POINTS, oldValue, points);
    }

}
