package fr.ird.observe.dto;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2017 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.dto.constants.ObserveDbRole;

public class ObserveDbUserDto extends AbstractObserveDto implements ObserveDto {

    public static final String PROPERTY_NAME = "name";

    public static final String PROPERTY_ROLE = "role";

    private static final long serialVersionUID = 3545852651782877286L;

    protected String name;

    protected ObserveDbRole role;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        String oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public ObserveDbRole getRole() {
        return role;
    }

    public void setRole(ObserveDbRole role) {
        ObserveDbRole oldValue = getRole();
        this.role = role;
        firePropertyChange(PROPERTY_ROLE, oldValue, role);
    }

}
