package fr.ird.observe.dto;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2008 - 2017 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import fr.ird.observe.binder.data.DataDtoReferenceBinderSupport;
import fr.ird.observe.binder.referential.ReferentialDtoReferenceBinderSupport;
import fr.ird.observe.dto.reference.DataDtoReferenceSupport;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceSupport;
import fr.ird.observe.dto.referential.ReferentialDto;
import io.ultreia.java4all.http.ImmutableClassMapping;
import io.ultreia.java4all.http.ImmutableClassMapping.Builder;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class DtoReferencesInitializerSupport {

    private final Map<String, DtoReferenceDefinition> referentialReferenceSetDefinitionBuilder = new TreeMap<>();

    private final Map<String, DtoReferenceDefinition> dataReferenceSetDefinitionBuilder = new TreeMap<>();

    private final Set<Class<? extends ReferentialDto>> referentialTypesBuilder = new LinkedHashSet<>();

    private final Set<Class<? extends DataDto>> dataTypesBuilder = new LinkedHashSet<>();

    private final Builder<IdDto, DtoReference> dtoToReferenceClassMappingBuilder = ImmutableClassMapping.builder();

    private final Builder<DtoReference, IdDto> referenceToDtoClassMappingBuilder = ImmutableClassMapping.builder();

    private final Map<String, ReferentialDtoReferenceBinderSupport> referentialBindersBuilder = new TreeMap<>();

    private final Map<String, DataDtoReferenceBinderSupport> dataBindersBuilder = new TreeMap<>();

    private ImmutableMap<String, DtoReferenceDefinition> referentialReferenceSetDefinition;

    private ImmutableMap<String, DtoReferenceDefinition> dataReferenceSetDefinition;

    private ImmutableSet<Class<? extends ReferentialDto>> referentialTypes;

    private ImmutableSet<Class<? extends DataDto>> dataTypes;

    private ImmutableClassMapping<IdDto, DtoReference> dtoToReferenceClassMapping;

    private ImmutableClassMapping<DtoReference, IdDto> referenceToDtoClassMapping;

    private ImmutableMap<String, ReferentialDtoReferenceBinderSupport> referentialBinders;

    private ImmutableMap<String, DataDtoReferenceBinderSupport> dataBinders;

    public ImmutableMap<String, DtoReferenceDefinition> getReferentialReferenceSetDefinition() {
        return referentialReferenceSetDefinition;
    }

    public ImmutableMap<String, DtoReferenceDefinition> getDataReferenceSetDefinition() {
        return dataReferenceSetDefinition;
    }

    public ImmutableSet<Class<? extends ReferentialDto>> getReferentialTypes() {
        return referentialTypes;
    }

    public ImmutableSet<Class<? extends DataDto>> getDataTypes() {
        return dataTypes;
    }

    public ImmutableClassMapping<IdDto, DtoReference> getDtoToReferenceClassMapping() {
        return dtoToReferenceClassMapping;
    }

    public ImmutableClassMapping<DtoReference, IdDto> getReferenceToDtoClassMapping() {
        return referenceToDtoClassMapping;
    }

    public ImmutableMap<String, ReferentialDtoReferenceBinderSupport> getReferentialBinders() {
        return referentialBinders;
    }

    public ImmutableMap<String, DataDtoReferenceBinderSupport> getDataBinders() {
        return dataBinders;
    }

    public void end() {
        referentialReferenceSetDefinition = ImmutableMap.copyOf(referentialReferenceSetDefinitionBuilder);
        dataReferenceSetDefinition = ImmutableMap.copyOf(dataReferenceSetDefinitionBuilder);
        referentialTypes = ImmutableSet.copyOf(referentialTypesBuilder);
        dataTypes = ImmutableSet.copyOf(dataTypesBuilder);
        dtoToReferenceClassMapping = dtoToReferenceClassMappingBuilder.build();
        referenceToDtoClassMapping = referenceToDtoClassMappingBuilder.build();
        referentialBinders = ImmutableMap.copyOf(referentialBindersBuilder);
        dataBinders = ImmutableMap.copyOf(dataBindersBuilder);
    }

    protected <D extends ReferentialDto, R extends ReferentialDtoReferenceSupport<D, R>> void flushReferential(DtoReferenceDefinition<D, R> result) {
        referentialTypesBuilder.add(result.getDtoType());
        referentialReferenceSetDefinitionBuilder.put(result.getKey(), result);
        dtoToReferenceClassMappingBuilder.put(result.getDtoType(), result.getType());
        referenceToDtoClassMappingBuilder.put(result.getType(), result.getDtoType());

    }

    protected <D extends DataDto, R extends DataDtoReferenceSupport<D, R>> void flushData(DtoReferenceDefinition<D, R> result) {
        dataTypesBuilder.add(result.getDtoType());
        dataReferenceSetDefinitionBuilder.put(result.getKey(), result);
        dtoToReferenceClassMappingBuilder.put(result.getDtoType(), result.getType());
        referenceToDtoClassMappingBuilder.put(result.getType(), result.getDtoType());
    }

    protected <D extends ReferentialDto, R extends ReferentialDtoReferenceSupport<D, R>, B extends ReferentialDtoReferenceBinderSupport<D, R>> void registerReferentialBinder(B binder) {
        referentialBindersBuilder.put(binder.getKey(), binder);
    }

    protected <D extends DataDto, R extends DataDtoReferenceSupport<D, R>, B extends DataDtoReferenceBinderSupport<D, R>> void registerDataBinder(B binder) {
        dataBindersBuilder.put(binder.getKey(), binder);
    }
}
